/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.CalloutPolicyInner;
import com.azure.resourcemanager.kusto.fluent.models.ClusterProperties;
import com.azure.resourcemanager.kusto.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.kusto.models.AcceptedAudiences;
import com.azure.resourcemanager.kusto.models.AzureSku;
import com.azure.resourcemanager.kusto.models.ClusterNetworkAccessFlag;
import com.azure.resourcemanager.kusto.models.EngineType;
import com.azure.resourcemanager.kusto.models.Identity;
import com.azure.resourcemanager.kusto.models.KeyVaultProperties;
import com.azure.resourcemanager.kusto.models.LanguageExtensionsList;
import com.azure.resourcemanager.kusto.models.MigrationClusterProperties;
import com.azure.resourcemanager.kusto.models.OptimizedAutoscale;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.PublicIpType;
import com.azure.resourcemanager.kusto.models.PublicNetworkAccess;
import com.azure.resourcemanager.kusto.models.State;
import com.azure.resourcemanager.kusto.models.TrustedExternalTenant;
import com.azure.resourcemanager.kusto.models.VirtualNetworkConfiguration;
import com.azure.resourcemanager.kusto.models.ZoneStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ClusterInner
extends Resource {
    private AzureSku sku;
    private SystemData systemData;
    private List<String> zones;
    private Identity identity;
    private ClusterProperties innerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterInner.class);

    public AzureSku sku() {
        return this.sku;
    }

    public ClusterInner withSku(AzureSku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public List<String> zones() {
        return this.zones;
    }

    public ClusterInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public ClusterInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    private ClusterProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public State state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String uri() {
        return this.innerProperties() == null ? null : this.innerProperties().uri();
    }

    public String dataIngestionUri() {
        return this.innerProperties() == null ? null : this.innerProperties().dataIngestionUri();
    }

    public String stateReason() {
        return this.innerProperties() == null ? null : this.innerProperties().stateReason();
    }

    public List<TrustedExternalTenant> trustedExternalTenants() {
        return this.innerProperties() == null ? null : this.innerProperties().trustedExternalTenants();
    }

    public ClusterInner withTrustedExternalTenants(List<TrustedExternalTenant> trustedExternalTenants) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withTrustedExternalTenants(trustedExternalTenants);
        return this;
    }

    public OptimizedAutoscale optimizedAutoscale() {
        return this.innerProperties() == null ? null : this.innerProperties().optimizedAutoscale();
    }

    public ClusterInner withOptimizedAutoscale(OptimizedAutoscale optimizedAutoscale) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withOptimizedAutoscale(optimizedAutoscale);
        return this;
    }

    public Boolean enableDiskEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().enableDiskEncryption();
    }

    public ClusterInner withEnableDiskEncryption(Boolean enableDiskEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withEnableDiskEncryption(enableDiskEncryption);
        return this;
    }

    public Boolean enableStreamingIngest() {
        return this.innerProperties() == null ? null : this.innerProperties().enableStreamingIngest();
    }

    public ClusterInner withEnableStreamingIngest(Boolean enableStreamingIngest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withEnableStreamingIngest(enableStreamingIngest);
        return this;
    }

    public VirtualNetworkConfiguration virtualNetworkConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkConfiguration();
    }

    public ClusterInner withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withVirtualNetworkConfiguration(virtualNetworkConfiguration);
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultProperties();
    }

    public ClusterInner withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withKeyVaultProperties(keyVaultProperties);
        return this;
    }

    public Boolean enablePurge() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePurge();
    }

    public ClusterInner withEnablePurge(Boolean enablePurge) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withEnablePurge(enablePurge);
        return this;
    }

    public LanguageExtensionsList languageExtensions() {
        return this.innerProperties() == null ? null : this.innerProperties().languageExtensions();
    }

    public ClusterInner withLanguageExtensions(LanguageExtensionsList languageExtensions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withLanguageExtensions(languageExtensions);
        return this;
    }

    public Boolean enableDoubleEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().enableDoubleEncryption();
    }

    public ClusterInner withEnableDoubleEncryption(Boolean enableDoubleEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withEnableDoubleEncryption(enableDoubleEncryption);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ClusterInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public List<String> allowedIpRangeList() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedIpRangeList();
    }

    public ClusterInner withAllowedIpRangeList(List<String> allowedIpRangeList) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withAllowedIpRangeList(allowedIpRangeList);
        return this;
    }

    public EngineType engineType() {
        return this.innerProperties() == null ? null : this.innerProperties().engineType();
    }

    public ClusterInner withEngineType(EngineType engineType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withEngineType(engineType);
        return this;
    }

    public List<AcceptedAudiences> acceptedAudiences() {
        return this.innerProperties() == null ? null : this.innerProperties().acceptedAudiences();
    }

    public ClusterInner withAcceptedAudiences(List<AcceptedAudiences> acceptedAudiences) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withAcceptedAudiences(acceptedAudiences);
        return this;
    }

    public Boolean enableAutoStop() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAutoStop();
    }

    public ClusterInner withEnableAutoStop(Boolean enableAutoStop) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withEnableAutoStop(enableAutoStop);
        return this;
    }

    public ClusterNetworkAccessFlag restrictOutboundNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().restrictOutboundNetworkAccess();
    }

    public ClusterInner withRestrictOutboundNetworkAccess(ClusterNetworkAccessFlag restrictOutboundNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withRestrictOutboundNetworkAccess(restrictOutboundNetworkAccess);
        return this;
    }

    public List<String> allowedFqdnList() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedFqdnList();
    }

    public ClusterInner withAllowedFqdnList(List<String> allowedFqdnList) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withAllowedFqdnList(allowedFqdnList);
        return this;
    }

    public List<CalloutPolicyInner> calloutPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().calloutPolicies();
    }

    public ClusterInner withCalloutPolicies(List<CalloutPolicyInner> calloutPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withCalloutPolicies(calloutPolicies);
        return this;
    }

    public PublicIpType publicIpType() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpType();
    }

    public ClusterInner withPublicIpType(PublicIpType publicIpType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withPublicIpType(publicIpType);
        return this;
    }

    public String virtualClusterGraduationProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualClusterGraduationProperties();
    }

    public ClusterInner withVirtualClusterGraduationProperties(String virtualClusterGraduationProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withVirtualClusterGraduationProperties(virtualClusterGraduationProperties);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public MigrationClusterProperties migrationCluster() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationCluster();
    }

    public ZoneStatus zoneStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneStatus();
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model ClusterInner"));
        }
        this.sku().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ClusterInner fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterInner)((Object)jsonReader.readObject(reader -> {
            ClusterInner deserializedClusterInner = new ClusterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClusterInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedClusterInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedClusterInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedClusterInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedClusterInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedClusterInner.sku = AzureSku.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedClusterInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedClusterInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedClusterInner.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedClusterInner.innerProperties = ClusterProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedClusterInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterInner;
        }));
    }
}

