/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.ClusterPrincipalRole;
import com.azure.resourcemanager.kusto.models.PrincipalType;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;

public final class ClusterPrincipalProperties
implements JsonSerializable<ClusterPrincipalProperties> {
    private String principalId;
    private ClusterPrincipalRole role;
    private String tenantId;
    private PrincipalType principalType;
    private String tenantName;
    private String principalName;
    private ProvisioningState provisioningState;
    private String aadObjectId;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterPrincipalProperties.class);

    public String principalId() {
        return this.principalId;
    }

    public ClusterPrincipalProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public ClusterPrincipalRole role() {
        return this.role;
    }

    public ClusterPrincipalProperties withRole(ClusterPrincipalRole role) {
        this.role = role;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ClusterPrincipalProperties withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public PrincipalType principalType() {
        return this.principalType;
    }

    public ClusterPrincipalProperties withPrincipalType(PrincipalType principalType) {
        this.principalType = principalType;
        return this;
    }

    public String tenantName() {
        return this.tenantName;
    }

    public String principalName() {
        return this.principalName;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String aadObjectId() {
        return this.aadObjectId;
    }

    public void validate() {
        if (this.principalId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property principalId in model ClusterPrincipalProperties"));
        }
        if (this.role() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property role in model ClusterPrincipalProperties"));
        }
        if (this.principalType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property principalType in model ClusterPrincipalProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("principalType", this.principalType == null ? null : this.principalType.toString());
        jsonWriter.writeStringField("tenantId", this.tenantId);
        return jsonWriter.writeEndObject();
    }

    public static ClusterPrincipalProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterPrincipalProperties)jsonReader.readObject(reader -> {
            ClusterPrincipalProperties deserializedClusterPrincipalProperties = new ClusterPrincipalProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedClusterPrincipalProperties.principalId = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    deserializedClusterPrincipalProperties.role = ClusterPrincipalRole.fromString(reader.getString());
                    continue;
                }
                if ("principalType".equals(fieldName)) {
                    deserializedClusterPrincipalProperties.principalType = PrincipalType.fromString(reader.getString());
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedClusterPrincipalProperties.tenantId = reader.getString();
                    continue;
                }
                if ("tenantName".equals(fieldName)) {
                    deserializedClusterPrincipalProperties.tenantName = reader.getString();
                    continue;
                }
                if ("principalName".equals(fieldName)) {
                    deserializedClusterPrincipalProperties.principalName = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterPrincipalProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("aadObjectId".equals(fieldName)) {
                    deserializedClusterPrincipalProperties.aadObjectId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterPrincipalProperties;
        });
    }
}

