/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class CosmosDbDataConnectionProperties
implements JsonSerializable<CosmosDbDataConnectionProperties> {
    private String tableName;
    private String mappingRuleName;
    private String managedIdentityResourceId;
    private String managedIdentityObjectId;
    private String cosmosDbAccountResourceId;
    private String cosmosDbDatabase;
    private String cosmosDbContainer;
    private OffsetDateTime retrievalStartDate;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(CosmosDbDataConnectionProperties.class);

    public String tableName() {
        return this.tableName;
    }

    public CosmosDbDataConnectionProperties withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String mappingRuleName() {
        return this.mappingRuleName;
    }

    public CosmosDbDataConnectionProperties withMappingRuleName(String mappingRuleName) {
        this.mappingRuleName = mappingRuleName;
        return this;
    }

    public String managedIdentityResourceId() {
        return this.managedIdentityResourceId;
    }

    public CosmosDbDataConnectionProperties withManagedIdentityResourceId(String managedIdentityResourceId) {
        this.managedIdentityResourceId = managedIdentityResourceId;
        return this;
    }

    public String managedIdentityObjectId() {
        return this.managedIdentityObjectId;
    }

    public String cosmosDbAccountResourceId() {
        return this.cosmosDbAccountResourceId;
    }

    public CosmosDbDataConnectionProperties withCosmosDbAccountResourceId(String cosmosDbAccountResourceId) {
        this.cosmosDbAccountResourceId = cosmosDbAccountResourceId;
        return this;
    }

    public String cosmosDbDatabase() {
        return this.cosmosDbDatabase;
    }

    public CosmosDbDataConnectionProperties withCosmosDbDatabase(String cosmosDbDatabase) {
        this.cosmosDbDatabase = cosmosDbDatabase;
        return this;
    }

    public String cosmosDbContainer() {
        return this.cosmosDbContainer;
    }

    public CosmosDbDataConnectionProperties withCosmosDbContainer(String cosmosDbContainer) {
        this.cosmosDbContainer = cosmosDbContainer;
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.retrievalStartDate;
    }

    public CosmosDbDataConnectionProperties withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        this.retrievalStartDate = retrievalStartDate;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.tableName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tableName in model CosmosDbDataConnectionProperties"));
        }
        if (this.managedIdentityResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property managedIdentityResourceId in model CosmosDbDataConnectionProperties"));
        }
        if (this.cosmosDbAccountResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property cosmosDbAccountResourceId in model CosmosDbDataConnectionProperties"));
        }
        if (this.cosmosDbDatabase() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property cosmosDbDatabase in model CosmosDbDataConnectionProperties"));
        }
        if (this.cosmosDbContainer() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property cosmosDbContainer in model CosmosDbDataConnectionProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tableName", this.tableName);
        jsonWriter.writeStringField("managedIdentityResourceId", this.managedIdentityResourceId);
        jsonWriter.writeStringField("cosmosDbAccountResourceId", this.cosmosDbAccountResourceId);
        jsonWriter.writeStringField("cosmosDbDatabase", this.cosmosDbDatabase);
        jsonWriter.writeStringField("cosmosDbContainer", this.cosmosDbContainer);
        jsonWriter.writeStringField("mappingRuleName", this.mappingRuleName);
        jsonWriter.writeStringField("retrievalStartDate", this.retrievalStartDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.retrievalStartDate));
        return jsonWriter.writeEndObject();
    }

    public static CosmosDbDataConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CosmosDbDataConnectionProperties)jsonReader.readObject(reader -> {
            CosmosDbDataConnectionProperties deserializedCosmosDbDataConnectionProperties = new CosmosDbDataConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tableName".equals(fieldName)) {
                    deserializedCosmosDbDataConnectionProperties.tableName = reader.getString();
                    continue;
                }
                if ("managedIdentityResourceId".equals(fieldName)) {
                    deserializedCosmosDbDataConnectionProperties.managedIdentityResourceId = reader.getString();
                    continue;
                }
                if ("cosmosDbAccountResourceId".equals(fieldName)) {
                    deserializedCosmosDbDataConnectionProperties.cosmosDbAccountResourceId = reader.getString();
                    continue;
                }
                if ("cosmosDbDatabase".equals(fieldName)) {
                    deserializedCosmosDbDataConnectionProperties.cosmosDbDatabase = reader.getString();
                    continue;
                }
                if ("cosmosDbContainer".equals(fieldName)) {
                    deserializedCosmosDbDataConnectionProperties.cosmosDbContainer = reader.getString();
                    continue;
                }
                if ("mappingRuleName".equals(fieldName)) {
                    deserializedCosmosDbDataConnectionProperties.mappingRuleName = reader.getString();
                    continue;
                }
                if ("managedIdentityObjectId".equals(fieldName)) {
                    deserializedCosmosDbDataConnectionProperties.managedIdentityObjectId = reader.getString();
                    continue;
                }
                if ("retrievalStartDate".equals(fieldName)) {
                    deserializedCosmosDbDataConnectionProperties.retrievalStartDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCosmosDbDataConnectionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCosmosDbDataConnectionProperties;
        });
    }
}

