/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.Kind;
import com.azure.resourcemanager.kusto.models.ReadOnlyFollowingDatabase;
import com.azure.resourcemanager.kusto.models.ReadWriteDatabase;
import java.io.IOException;

public class DatabaseInner
extends ProxyResource {
    private Kind kind = Kind.fromString("Database");
    private String location;
    private String type;
    private String name;
    private String id;

    public Kind kind() {
        return this.kind;
    }

    public String location() {
        return this.location;
    }

    public DatabaseInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseInner fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseInner)((Object)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DatabaseInner databaseInner;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ReadWrite".equals(discriminatorValue)) {
                    databaseInner = ReadWriteDatabase.fromJson(readerToUse.reset());
                    return databaseInner;
                }
                if ("ReadOnlyFollowing".equals(discriminatorValue)) {
                    databaseInner = ReadOnlyFollowingDatabase.fromJson(readerToUse.reset());
                    return databaseInner;
                }
                databaseInner = DatabaseInner.fromJsonKnownDiscriminator(readerToUse.reset());
                return databaseInner;
            }
        }));
    }

    static DatabaseInner fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DatabaseInner)((Object)jsonReader.readObject(reader -> {
            DatabaseInner deserializedDatabaseInner = new DatabaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDatabaseInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDatabaseInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDatabaseInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDatabaseInner.kind = Kind.fromString(reader.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDatabaseInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseInner;
        }));
    }
}

