/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.DatabasePrincipalProperties;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalRole;
import com.azure.resourcemanager.kusto.models.PrincipalType;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;

public final class DatabasePrincipalAssignmentInner
extends ProxyResource {
    private DatabasePrincipalProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private DatabasePrincipalProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    public DatabasePrincipalAssignmentInner withPrincipalId(String principalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabasePrincipalProperties();
        }
        this.innerProperties().withPrincipalId(principalId);
        return this;
    }

    public DatabasePrincipalRole role() {
        return this.innerProperties() == null ? null : this.innerProperties().role();
    }

    public DatabasePrincipalAssignmentInner withRole(DatabasePrincipalRole role) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabasePrincipalProperties();
        }
        this.innerProperties().withRole(role);
        return this;
    }

    public String tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    public DatabasePrincipalAssignmentInner withTenantId(String tenantId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabasePrincipalProperties();
        }
        this.innerProperties().withTenantId(tenantId);
        return this;
    }

    public PrincipalType principalType() {
        return this.innerProperties() == null ? null : this.innerProperties().principalType();
    }

    public DatabasePrincipalAssignmentInner withPrincipalType(PrincipalType principalType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabasePrincipalProperties();
        }
        this.innerProperties().withPrincipalType(principalType);
        return this;
    }

    public String tenantName() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantName();
    }

    public String principalName() {
        return this.innerProperties() == null ? null : this.innerProperties().principalName();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String aadObjectId() {
        return this.innerProperties() == null ? null : this.innerProperties().aadObjectId();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DatabasePrincipalAssignmentInner fromJson(JsonReader jsonReader) throws IOException {
        return (DatabasePrincipalAssignmentInner)((Object)jsonReader.readObject(reader -> {
            DatabasePrincipalAssignmentInner deserializedDatabasePrincipalAssignmentInner = new DatabasePrincipalAssignmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDatabasePrincipalAssignmentInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDatabasePrincipalAssignmentInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDatabasePrincipalAssignmentInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDatabasePrincipalAssignmentInner.innerProperties = DatabasePrincipalProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabasePrincipalAssignmentInner;
        }));
    }
}

