/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalRole;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalType;
import java.io.IOException;

public final class DatabasePrincipalInner
implements JsonSerializable<DatabasePrincipalInner> {
    private DatabasePrincipalRole role;
    private String name;
    private DatabasePrincipalType type;
    private String fqn;
    private String email;
    private String appId;
    private String tenantName;
    private static final ClientLogger LOGGER = new ClientLogger(DatabasePrincipalInner.class);

    public DatabasePrincipalRole role() {
        return this.role;
    }

    public DatabasePrincipalInner withRole(DatabasePrincipalRole role) {
        this.role = role;
        return this;
    }

    public String name() {
        return this.name;
    }

    public DatabasePrincipalInner withName(String name) {
        this.name = name;
        return this;
    }

    public DatabasePrincipalType type() {
        return this.type;
    }

    public DatabasePrincipalInner withType(DatabasePrincipalType type) {
        this.type = type;
        return this;
    }

    public String fqn() {
        return this.fqn;
    }

    public DatabasePrincipalInner withFqn(String fqn) {
        this.fqn = fqn;
        return this;
    }

    public String email() {
        return this.email;
    }

    public DatabasePrincipalInner withEmail(String email) {
        this.email = email;
        return this;
    }

    public String appId() {
        return this.appId;
    }

    public DatabasePrincipalInner withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String tenantName() {
        return this.tenantName;
    }

    public void validate() {
        if (this.role() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property role in model DatabasePrincipalInner"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model DatabasePrincipalInner"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model DatabasePrincipalInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("fqn", this.fqn);
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeStringField("appId", this.appId);
        return jsonWriter.writeEndObject();
    }

    public static DatabasePrincipalInner fromJson(JsonReader jsonReader) throws IOException {
        return (DatabasePrincipalInner)jsonReader.readObject(reader -> {
            DatabasePrincipalInner deserializedDatabasePrincipalInner = new DatabasePrincipalInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    deserializedDatabasePrincipalInner.role = DatabasePrincipalRole.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDatabasePrincipalInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDatabasePrincipalInner.type = DatabasePrincipalType.fromString(reader.getString());
                    continue;
                }
                if ("fqn".equals(fieldName)) {
                    deserializedDatabasePrincipalInner.fqn = reader.getString();
                    continue;
                }
                if ("email".equals(fieldName)) {
                    deserializedDatabasePrincipalInner.email = reader.getString();
                    continue;
                }
                if ("appId".equals(fieldName)) {
                    deserializedDatabasePrincipalInner.appId = reader.getString();
                    continue;
                }
                if ("tenantName".equals(fieldName)) {
                    deserializedDatabasePrincipalInner.tenantName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabasePrincipalInner;
        });
    }
}

