/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.Compression;
import com.azure.resourcemanager.kusto.models.DatabaseRouting;
import com.azure.resourcemanager.kusto.models.EventHubDataFormat;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class EventHubConnectionProperties
implements JsonSerializable<EventHubConnectionProperties> {
    private String eventHubResourceId;
    private String consumerGroup;
    private String tableName;
    private String mappingRuleName;
    private EventHubDataFormat dataFormat;
    private List<String> eventSystemProperties;
    private Compression compression;
    private ProvisioningState provisioningState;
    private String managedIdentityResourceId;
    private String managedIdentityObjectId;
    private DatabaseRouting databaseRouting;
    private OffsetDateTime retrievalStartDate;
    private static final ClientLogger LOGGER = new ClientLogger(EventHubConnectionProperties.class);

    public String eventHubResourceId() {
        return this.eventHubResourceId;
    }

    public EventHubConnectionProperties withEventHubResourceId(String eventHubResourceId) {
        this.eventHubResourceId = eventHubResourceId;
        return this;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public EventHubConnectionProperties withConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    public String tableName() {
        return this.tableName;
    }

    public EventHubConnectionProperties withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String mappingRuleName() {
        return this.mappingRuleName;
    }

    public EventHubConnectionProperties withMappingRuleName(String mappingRuleName) {
        this.mappingRuleName = mappingRuleName;
        return this;
    }

    public EventHubDataFormat dataFormat() {
        return this.dataFormat;
    }

    public EventHubConnectionProperties withDataFormat(EventHubDataFormat dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public List<String> eventSystemProperties() {
        return this.eventSystemProperties;
    }

    public EventHubConnectionProperties withEventSystemProperties(List<String> eventSystemProperties) {
        this.eventSystemProperties = eventSystemProperties;
        return this;
    }

    public Compression compression() {
        return this.compression;
    }

    public EventHubConnectionProperties withCompression(Compression compression) {
        this.compression = compression;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String managedIdentityResourceId() {
        return this.managedIdentityResourceId;
    }

    public EventHubConnectionProperties withManagedIdentityResourceId(String managedIdentityResourceId) {
        this.managedIdentityResourceId = managedIdentityResourceId;
        return this;
    }

    public String managedIdentityObjectId() {
        return this.managedIdentityObjectId;
    }

    public DatabaseRouting databaseRouting() {
        return this.databaseRouting;
    }

    public EventHubConnectionProperties withDatabaseRouting(DatabaseRouting databaseRouting) {
        this.databaseRouting = databaseRouting;
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.retrievalStartDate;
    }

    public EventHubConnectionProperties withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        this.retrievalStartDate = retrievalStartDate;
        return this;
    }

    public void validate() {
        if (this.eventHubResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property eventHubResourceId in model EventHubConnectionProperties"));
        }
        if (this.consumerGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property consumerGroup in model EventHubConnectionProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("eventHubResourceId", this.eventHubResourceId);
        jsonWriter.writeStringField("consumerGroup", this.consumerGroup);
        jsonWriter.writeStringField("tableName", this.tableName);
        jsonWriter.writeStringField("mappingRuleName", this.mappingRuleName);
        jsonWriter.writeStringField("dataFormat", this.dataFormat == null ? null : this.dataFormat.toString());
        jsonWriter.writeArrayField("eventSystemProperties", this.eventSystemProperties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("compression", this.compression == null ? null : this.compression.toString());
        jsonWriter.writeStringField("managedIdentityResourceId", this.managedIdentityResourceId);
        jsonWriter.writeStringField("databaseRouting", this.databaseRouting == null ? null : this.databaseRouting.toString());
        jsonWriter.writeStringField("retrievalStartDate", this.retrievalStartDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.retrievalStartDate));
        return jsonWriter.writeEndObject();
    }

    public static EventHubConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EventHubConnectionProperties)jsonReader.readObject(reader -> {
            EventHubConnectionProperties deserializedEventHubConnectionProperties = new EventHubConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("eventHubResourceId".equals(fieldName)) {
                    deserializedEventHubConnectionProperties.eventHubResourceId = reader.getString();
                    continue;
                }
                if ("consumerGroup".equals(fieldName)) {
                    deserializedEventHubConnectionProperties.consumerGroup = reader.getString();
                    continue;
                }
                if ("tableName".equals(fieldName)) {
                    deserializedEventHubConnectionProperties.tableName = reader.getString();
                    continue;
                }
                if ("mappingRuleName".equals(fieldName)) {
                    deserializedEventHubConnectionProperties.mappingRuleName = reader.getString();
                    continue;
                }
                if ("dataFormat".equals(fieldName)) {
                    deserializedEventHubConnectionProperties.dataFormat = EventHubDataFormat.fromString(reader.getString());
                    continue;
                }
                if ("eventSystemProperties".equals(fieldName)) {
                    List eventSystemProperties;
                    deserializedEventHubConnectionProperties.eventSystemProperties = eventSystemProperties = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("compression".equals(fieldName)) {
                    deserializedEventHubConnectionProperties.compression = Compression.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedEventHubConnectionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("managedIdentityResourceId".equals(fieldName)) {
                    deserializedEventHubConnectionProperties.managedIdentityResourceId = reader.getString();
                    continue;
                }
                if ("managedIdentityObjectId".equals(fieldName)) {
                    deserializedEventHubConnectionProperties.managedIdentityObjectId = reader.getString();
                    continue;
                }
                if ("databaseRouting".equals(fieldName)) {
                    deserializedEventHubConnectionProperties.databaseRouting = DatabaseRouting.fromString(reader.getString());
                    continue;
                }
                if ("retrievalStartDate".equals(fieldName)) {
                    deserializedEventHubConnectionProperties.retrievalStartDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventHubConnectionProperties;
        });
    }
}

