/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.DatabaseShareOrigin;
import com.azure.resourcemanager.kusto.models.TableLevelSharingProperties;
import java.io.IOException;

public final class FollowerDatabaseDefinitionInner
implements JsonSerializable<FollowerDatabaseDefinitionInner> {
    private String clusterResourceId;
    private String attachedDatabaseConfigurationName;
    private String databaseName;
    private TableLevelSharingProperties tableLevelSharingProperties;
    private DatabaseShareOrigin databaseShareOrigin;
    private static final ClientLogger LOGGER = new ClientLogger(FollowerDatabaseDefinitionInner.class);

    public String clusterResourceId() {
        return this.clusterResourceId;
    }

    public FollowerDatabaseDefinitionInner withClusterResourceId(String clusterResourceId) {
        this.clusterResourceId = clusterResourceId;
        return this;
    }

    public String attachedDatabaseConfigurationName() {
        return this.attachedDatabaseConfigurationName;
    }

    public FollowerDatabaseDefinitionInner withAttachedDatabaseConfigurationName(String attachedDatabaseConfigurationName) {
        this.attachedDatabaseConfigurationName = attachedDatabaseConfigurationName;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public TableLevelSharingProperties tableLevelSharingProperties() {
        return this.tableLevelSharingProperties;
    }

    public DatabaseShareOrigin databaseShareOrigin() {
        return this.databaseShareOrigin;
    }

    public void validate() {
        if (this.clusterResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clusterResourceId in model FollowerDatabaseDefinitionInner"));
        }
        if (this.attachedDatabaseConfigurationName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property attachedDatabaseConfigurationName in model FollowerDatabaseDefinitionInner"));
        }
        if (this.tableLevelSharingProperties() != null) {
            this.tableLevelSharingProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clusterResourceId", this.clusterResourceId);
        jsonWriter.writeStringField("attachedDatabaseConfigurationName", this.attachedDatabaseConfigurationName);
        return jsonWriter.writeEndObject();
    }

    public static FollowerDatabaseDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return (FollowerDatabaseDefinitionInner)jsonReader.readObject(reader -> {
            FollowerDatabaseDefinitionInner deserializedFollowerDatabaseDefinitionInner = new FollowerDatabaseDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clusterResourceId".equals(fieldName)) {
                    deserializedFollowerDatabaseDefinitionInner.clusterResourceId = reader.getString();
                    continue;
                }
                if ("attachedDatabaseConfigurationName".equals(fieldName)) {
                    deserializedFollowerDatabaseDefinitionInner.attachedDatabaseConfigurationName = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedFollowerDatabaseDefinitionInner.databaseName = reader.getString();
                    continue;
                }
                if ("tableLevelSharingProperties".equals(fieldName)) {
                    deserializedFollowerDatabaseDefinitionInner.tableLevelSharingProperties = TableLevelSharingProperties.fromJson(reader);
                    continue;
                }
                if ("databaseShareOrigin".equals(fieldName)) {
                    deserializedFollowerDatabaseDefinitionInner.databaseShareOrigin = DatabaseShareOrigin.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFollowerDatabaseDefinitionInner;
        });
    }
}

