/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;

public final class ManagedPrivateEndpointProperties
implements JsonSerializable<ManagedPrivateEndpointProperties> {
    private String privateLinkResourceId;
    private String privateLinkResourceRegion;
    private String groupId;
    private String requestMessage;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedPrivateEndpointProperties.class);

    public String privateLinkResourceId() {
        return this.privateLinkResourceId;
    }

    public ManagedPrivateEndpointProperties withPrivateLinkResourceId(String privateLinkResourceId) {
        this.privateLinkResourceId = privateLinkResourceId;
        return this;
    }

    public String privateLinkResourceRegion() {
        return this.privateLinkResourceRegion;
    }

    public ManagedPrivateEndpointProperties withPrivateLinkResourceRegion(String privateLinkResourceRegion) {
        this.privateLinkResourceRegion = privateLinkResourceRegion;
        return this;
    }

    public String groupId() {
        return this.groupId;
    }

    public ManagedPrivateEndpointProperties withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String requestMessage() {
        return this.requestMessage;
    }

    public ManagedPrivateEndpointProperties withRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.privateLinkResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property privateLinkResourceId in model ManagedPrivateEndpointProperties"));
        }
        if (this.groupId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property groupId in model ManagedPrivateEndpointProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateLinkResourceId", this.privateLinkResourceId);
        jsonWriter.writeStringField("groupId", this.groupId);
        jsonWriter.writeStringField("privateLinkResourceRegion", this.privateLinkResourceRegion);
        jsonWriter.writeStringField("requestMessage", this.requestMessage);
        return jsonWriter.writeEndObject();
    }

    public static ManagedPrivateEndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedPrivateEndpointProperties)jsonReader.readObject(reader -> {
            ManagedPrivateEndpointProperties deserializedManagedPrivateEndpointProperties = new ManagedPrivateEndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateLinkResourceId".equals(fieldName)) {
                    deserializedManagedPrivateEndpointProperties.privateLinkResourceId = reader.getString();
                    continue;
                }
                if ("groupId".equals(fieldName)) {
                    deserializedManagedPrivateEndpointProperties.groupId = reader.getString();
                    continue;
                }
                if ("privateLinkResourceRegion".equals(fieldName)) {
                    deserializedManagedPrivateEndpointProperties.privateLinkResourceRegion = reader.getString();
                    continue;
                }
                if ("requestMessage".equals(fieldName)) {
                    deserializedManagedPrivateEndpointProperties.requestMessage = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedPrivateEndpointProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedPrivateEndpointProperties;
        });
    }
}

