/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.OperationResultErrorProperties;
import com.azure.resourcemanager.kusto.fluent.models.OperationResultProperties;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.Status;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class OperationResultInner
implements JsonSerializable<OperationResultInner> {
    private String id;
    private String name;
    private Status status;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Double percentComplete;
    private OperationResultProperties innerProperties;
    private OperationResultErrorProperties innerError;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Status status() {
        return this.status;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OperationResultInner withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public OperationResultInner withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public Double percentComplete() {
        return this.percentComplete;
    }

    public OperationResultInner withPercentComplete(Double percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    private OperationResultProperties innerProperties() {
        return this.innerProperties;
    }

    private OperationResultErrorProperties innerError() {
        return this.innerError;
    }

    public String operationKind() {
        return this.innerProperties() == null ? null : this.innerProperties().operationKind();
    }

    public OperationResultInner withOperationKind(String operationKind) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationResultProperties();
        }
        this.innerProperties().withOperationKind(operationKind);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String operationState() {
        return this.innerProperties() == null ? null : this.innerProperties().operationState();
    }

    public OperationResultInner withOperationState(String operationState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationResultProperties();
        }
        this.innerProperties().withOperationState(operationState);
        return this;
    }

    public String code() {
        return this.innerError() == null ? null : this.innerError().code();
    }

    public OperationResultInner withCode(String code) {
        if (this.innerError() == null) {
            this.innerError = new OperationResultErrorProperties();
        }
        this.innerError().withCode(code);
        return this;
    }

    public String message() {
        return this.innerError() == null ? null : this.innerError().message();
    }

    public OperationResultInner withMessage(String message) {
        if (this.innerError() == null) {
            this.innerError = new OperationResultErrorProperties();
        }
        this.innerError().withMessage(message);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.innerError() != null) {
            this.innerError().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeNumberField("percentComplete", (Number)this.percentComplete);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.innerError);
        return jsonWriter.writeEndObject();
    }

    public static OperationResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationResultInner)jsonReader.readObject(reader -> {
            OperationResultInner deserializedOperationResultInner = new OperationResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedOperationResultInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOperationResultInner.name = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedOperationResultInner.status = Status.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedOperationResultInner.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedOperationResultInner.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedOperationResultInner.percentComplete = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperationResultInner.innerProperties = OperationResultProperties.fromJson(reader);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedOperationResultInner.innerError = OperationResultErrorProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationResultInner;
        });
    }
}

