/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.EndpointDependency;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class OutboundNetworkDependenciesEndpointProperties
implements JsonSerializable<OutboundNetworkDependenciesEndpointProperties> {
    private String category;
    private List<EndpointDependency> endpoints;
    private ProvisioningState provisioningState;

    public String category() {
        return this.category;
    }

    public OutboundNetworkDependenciesEndpointProperties withCategory(String category) {
        this.category = category;
        return this;
    }

    public List<EndpointDependency> endpoints() {
        return this.endpoints;
    }

    public OutboundNetworkDependenciesEndpointProperties withEndpoints(List<EndpointDependency> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OutboundNetworkDependenciesEndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OutboundNetworkDependenciesEndpointProperties)jsonReader.readObject(reader -> {
            OutboundNetworkDependenciesEndpointProperties deserializedOutboundNetworkDependenciesEndpointProperties = new OutboundNetworkDependenciesEndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("category".equals(fieldName)) {
                    deserializedOutboundNetworkDependenciesEndpointProperties.category = reader.getString();
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List endpoints;
                    deserializedOutboundNetworkDependenciesEndpointProperties.endpoints = endpoints = reader.readArray(reader1 -> EndpointDependency.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedOutboundNetworkDependenciesEndpointProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOutboundNetworkDependenciesEndpointProperties;
        });
    }
}

