/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.DatabaseShareOrigin;
import com.azure.resourcemanager.kusto.models.DatabaseStatistics;
import com.azure.resourcemanager.kusto.models.PrincipalsModificationKind;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.SuspensionDetails;
import com.azure.resourcemanager.kusto.models.TableLevelSharingProperties;
import java.io.IOException;
import java.time.Duration;

public final class ReadOnlyFollowingDatabaseProperties
implements JsonSerializable<ReadOnlyFollowingDatabaseProperties> {
    private ProvisioningState provisioningState;
    private Duration softDeletePeriod;
    private Duration hotCachePeriod;
    private DatabaseStatistics statistics;
    private String leaderClusterResourceId;
    private String attachedDatabaseConfigurationName;
    private PrincipalsModificationKind principalsModificationKind;
    private TableLevelSharingProperties tableLevelSharingProperties;
    private String originalDatabaseName;
    private DatabaseShareOrigin databaseShareOrigin;
    private SuspensionDetails suspensionDetails;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Duration softDeletePeriod() {
        return this.softDeletePeriod;
    }

    public Duration hotCachePeriod() {
        return this.hotCachePeriod;
    }

    public ReadOnlyFollowingDatabaseProperties withHotCachePeriod(Duration hotCachePeriod) {
        this.hotCachePeriod = hotCachePeriod;
        return this;
    }

    public DatabaseStatistics statistics() {
        return this.statistics;
    }

    public String leaderClusterResourceId() {
        return this.leaderClusterResourceId;
    }

    public String attachedDatabaseConfigurationName() {
        return this.attachedDatabaseConfigurationName;
    }

    public PrincipalsModificationKind principalsModificationKind() {
        return this.principalsModificationKind;
    }

    public TableLevelSharingProperties tableLevelSharingProperties() {
        return this.tableLevelSharingProperties;
    }

    public String originalDatabaseName() {
        return this.originalDatabaseName;
    }

    public DatabaseShareOrigin databaseShareOrigin() {
        return this.databaseShareOrigin;
    }

    public SuspensionDetails suspensionDetails() {
        return this.suspensionDetails;
    }

    public void validate() {
        if (this.statistics() != null) {
            this.statistics().validate();
        }
        if (this.tableLevelSharingProperties() != null) {
            this.tableLevelSharingProperties().validate();
        }
        if (this.suspensionDetails() != null) {
            this.suspensionDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hotCachePeriod", CoreUtils.durationToStringWithDays((Duration)this.hotCachePeriod));
        return jsonWriter.writeEndObject();
    }

    public static ReadOnlyFollowingDatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ReadOnlyFollowingDatabaseProperties)jsonReader.readObject(reader -> {
            ReadOnlyFollowingDatabaseProperties deserializedReadOnlyFollowingDatabaseProperties = new ReadOnlyFollowingDatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabaseProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("softDeletePeriod".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabaseProperties.softDeletePeriod = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("hotCachePeriod".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabaseProperties.hotCachePeriod = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabaseProperties.statistics = DatabaseStatistics.fromJson(reader);
                    continue;
                }
                if ("leaderClusterResourceId".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabaseProperties.leaderClusterResourceId = reader.getString();
                    continue;
                }
                if ("attachedDatabaseConfigurationName".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabaseProperties.attachedDatabaseConfigurationName = reader.getString();
                    continue;
                }
                if ("principalsModificationKind".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabaseProperties.principalsModificationKind = PrincipalsModificationKind.fromString(reader.getString());
                    continue;
                }
                if ("tableLevelSharingProperties".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabaseProperties.tableLevelSharingProperties = TableLevelSharingProperties.fromJson(reader);
                    continue;
                }
                if ("originalDatabaseName".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabaseProperties.originalDatabaseName = reader.getString();
                    continue;
                }
                if ("databaseShareOrigin".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabaseProperties.databaseShareOrigin = DatabaseShareOrigin.fromString(reader.getString());
                    continue;
                }
                if ("suspensionDetails".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabaseProperties.suspensionDetails = SuspensionDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReadOnlyFollowingDatabaseProperties;
        });
    }
}

