/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.DatabaseStatistics;
import com.azure.resourcemanager.kusto.models.KeyVaultProperties;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.SuspensionDetails;
import java.io.IOException;
import java.time.Duration;

public final class ReadWriteDatabaseProperties
implements JsonSerializable<ReadWriteDatabaseProperties> {
    private ProvisioningState provisioningState;
    private Duration softDeletePeriod;
    private Duration hotCachePeriod;
    private DatabaseStatistics statistics;
    private Boolean isFollowed;
    private KeyVaultProperties keyVaultProperties;
    private SuspensionDetails suspensionDetails;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Duration softDeletePeriod() {
        return this.softDeletePeriod;
    }

    public ReadWriteDatabaseProperties withSoftDeletePeriod(Duration softDeletePeriod) {
        this.softDeletePeriod = softDeletePeriod;
        return this;
    }

    public Duration hotCachePeriod() {
        return this.hotCachePeriod;
    }

    public ReadWriteDatabaseProperties withHotCachePeriod(Duration hotCachePeriod) {
        this.hotCachePeriod = hotCachePeriod;
        return this;
    }

    public DatabaseStatistics statistics() {
        return this.statistics;
    }

    public Boolean isFollowed() {
        return this.isFollowed;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public ReadWriteDatabaseProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public SuspensionDetails suspensionDetails() {
        return this.suspensionDetails;
    }

    public void validate() {
        if (this.statistics() != null) {
            this.statistics().validate();
        }
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.suspensionDetails() != null) {
            this.suspensionDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("softDeletePeriod", CoreUtils.durationToStringWithDays((Duration)this.softDeletePeriod));
        jsonWriter.writeStringField("hotCachePeriod", CoreUtils.durationToStringWithDays((Duration)this.hotCachePeriod));
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        return jsonWriter.writeEndObject();
    }

    public static ReadWriteDatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ReadWriteDatabaseProperties)jsonReader.readObject(reader -> {
            ReadWriteDatabaseProperties deserializedReadWriteDatabaseProperties = new ReadWriteDatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedReadWriteDatabaseProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("softDeletePeriod".equals(fieldName)) {
                    deserializedReadWriteDatabaseProperties.softDeletePeriod = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("hotCachePeriod".equals(fieldName)) {
                    deserializedReadWriteDatabaseProperties.hotCachePeriod = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedReadWriteDatabaseProperties.statistics = DatabaseStatistics.fromJson(reader);
                    continue;
                }
                if ("isFollowed".equals(fieldName)) {
                    deserializedReadWriteDatabaseProperties.isFollowed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedReadWriteDatabaseProperties.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("suspensionDetails".equals(fieldName)) {
                    deserializedReadWriteDatabaseProperties.suspensionDetails = SuspensionDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReadWriteDatabaseProperties;
        });
    }
}

