/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.PrincipalPermissionsAction;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.ScriptLevel;
import java.io.IOException;

public final class ScriptProperties
implements JsonSerializable<ScriptProperties> {
    private String scriptUrl;
    private String scriptUrlSasToken;
    private String scriptContent;
    private String forceUpdateTag;
    private Boolean continueOnErrors;
    private ProvisioningState provisioningState;
    private ScriptLevel scriptLevel;
    private PrincipalPermissionsAction principalPermissionsAction;

    public String scriptUrl() {
        return this.scriptUrl;
    }

    public ScriptProperties withScriptUrl(String scriptUrl) {
        this.scriptUrl = scriptUrl;
        return this;
    }

    public String scriptUrlSasToken() {
        return this.scriptUrlSasToken;
    }

    public ScriptProperties withScriptUrlSasToken(String scriptUrlSasToken) {
        this.scriptUrlSasToken = scriptUrlSasToken;
        return this;
    }

    public String scriptContent() {
        return this.scriptContent;
    }

    public ScriptProperties withScriptContent(String scriptContent) {
        this.scriptContent = scriptContent;
        return this;
    }

    public String forceUpdateTag() {
        return this.forceUpdateTag;
    }

    public ScriptProperties withForceUpdateTag(String forceUpdateTag) {
        this.forceUpdateTag = forceUpdateTag;
        return this;
    }

    public Boolean continueOnErrors() {
        return this.continueOnErrors;
    }

    public ScriptProperties withContinueOnErrors(Boolean continueOnErrors) {
        this.continueOnErrors = continueOnErrors;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ScriptLevel scriptLevel() {
        return this.scriptLevel;
    }

    public ScriptProperties withScriptLevel(ScriptLevel scriptLevel) {
        this.scriptLevel = scriptLevel;
        return this;
    }

    public PrincipalPermissionsAction principalPermissionsAction() {
        return this.principalPermissionsAction;
    }

    public ScriptProperties withPrincipalPermissionsAction(PrincipalPermissionsAction principalPermissionsAction) {
        this.principalPermissionsAction = principalPermissionsAction;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scriptUrl", this.scriptUrl);
        jsonWriter.writeStringField("scriptUrlSasToken", this.scriptUrlSasToken);
        jsonWriter.writeStringField("scriptContent", this.scriptContent);
        jsonWriter.writeStringField("forceUpdateTag", this.forceUpdateTag);
        jsonWriter.writeBooleanField("continueOnErrors", this.continueOnErrors);
        jsonWriter.writeStringField("scriptLevel", this.scriptLevel == null ? null : this.scriptLevel.toString());
        jsonWriter.writeStringField("principalPermissionsAction", this.principalPermissionsAction == null ? null : this.principalPermissionsAction.toString());
        return jsonWriter.writeEndObject();
    }

    public static ScriptProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ScriptProperties)jsonReader.readObject(reader -> {
            ScriptProperties deserializedScriptProperties = new ScriptProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scriptUrl".equals(fieldName)) {
                    deserializedScriptProperties.scriptUrl = reader.getString();
                    continue;
                }
                if ("scriptUrlSasToken".equals(fieldName)) {
                    deserializedScriptProperties.scriptUrlSasToken = reader.getString();
                    continue;
                }
                if ("scriptContent".equals(fieldName)) {
                    deserializedScriptProperties.scriptContent = reader.getString();
                    continue;
                }
                if ("forceUpdateTag".equals(fieldName)) {
                    deserializedScriptProperties.forceUpdateTag = reader.getString();
                    continue;
                }
                if ("continueOnErrors".equals(fieldName)) {
                    deserializedScriptProperties.continueOnErrors = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedScriptProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("scriptLevel".equals(fieldName)) {
                    deserializedScriptProperties.scriptLevel = ScriptLevel.fromString(reader.getString());
                    continue;
                }
                if ("principalPermissionsAction".equals(fieldName)) {
                    deserializedScriptProperties.principalPermissionsAction = PrincipalPermissionsAction.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScriptProperties;
        });
    }
}

