/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.SkuLocationInfoItem;
import java.io.IOException;
import java.util.List;

public final class SkuDescriptionInner
implements JsonSerializable<SkuDescriptionInner> {
    private String resourceType;
    private String name;
    private String tier;
    private List<String> locations;
    private List<SkuLocationInfoItem> locationInfo;
    private List<Object> restrictions;

    public String resourceType() {
        return this.resourceType;
    }

    public String name() {
        return this.name;
    }

    public String tier() {
        return this.tier;
    }

    public List<String> locations() {
        return this.locations;
    }

    public List<SkuLocationInfoItem> locationInfo() {
        return this.locationInfo;
    }

    public List<Object> restrictions() {
        return this.restrictions;
    }

    public void validate() {
        if (this.locationInfo() != null) {
            this.locationInfo().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SkuDescriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return (SkuDescriptionInner)jsonReader.readObject(reader -> {
            SkuDescriptionInner deserializedSkuDescriptionInner = new SkuDescriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceType".equals(fieldName)) {
                    deserializedSkuDescriptionInner.resourceType = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSkuDescriptionInner.name = reader.getString();
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedSkuDescriptionInner.tier = reader.getString();
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedSkuDescriptionInner.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("locationInfo".equals(fieldName)) {
                    List locationInfo;
                    deserializedSkuDescriptionInner.locationInfo = locationInfo = reader.readArray(reader1 -> SkuLocationInfoItem.fromJson(reader1));
                    continue;
                }
                if ("restrictions".equals(fieldName)) {
                    List restrictions;
                    deserializedSkuDescriptionInner.restrictions = restrictions = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuDescriptionInner;
        });
    }
}

