/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.ClusterPrincipalAssignmentsClient;
import com.azure.resourcemanager.kusto.fluent.models.CheckNameResultInner;
import com.azure.resourcemanager.kusto.fluent.models.ClusterPrincipalAssignmentInner;
import com.azure.resourcemanager.kusto.implementation.CheckNameResultImpl;
import com.azure.resourcemanager.kusto.implementation.ClusterPrincipalAssignmentImpl;
import com.azure.resourcemanager.kusto.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.kusto.models.CheckNameResult;
import com.azure.resourcemanager.kusto.models.ClusterPrincipalAssignment;
import com.azure.resourcemanager.kusto.models.ClusterPrincipalAssignmentCheckNameRequest;
import com.azure.resourcemanager.kusto.models.ClusterPrincipalAssignments;

public final class ClusterPrincipalAssignmentsImpl
implements ClusterPrincipalAssignments {
    private static final ClientLogger LOGGER = new ClientLogger(ClusterPrincipalAssignmentsImpl.class);
    private final ClusterPrincipalAssignmentsClient innerClient;
    private final KustoManager serviceManager;

    public ClusterPrincipalAssignmentsImpl(ClusterPrincipalAssignmentsClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CheckNameResult> checkNameAvailabilityWithResponse(String resourceGroupName, String clusterName, ClusterPrincipalAssignmentCheckNameRequest principalAssignmentName, Context context) {
        Response<CheckNameResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(resourceGroupName, clusterName, principalAssignmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameResultImpl((CheckNameResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameResult checkNameAvailability(String resourceGroupName, String clusterName, ClusterPrincipalAssignmentCheckNameRequest principalAssignmentName) {
        CheckNameResultInner inner = this.serviceClient().checkNameAvailability(resourceGroupName, clusterName, principalAssignmentName);
        if (inner != null) {
            return new CheckNameResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ClusterPrincipalAssignment> getWithResponse(String resourceGroupName, String clusterName, String principalAssignmentName, Context context) {
        Response<ClusterPrincipalAssignmentInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, principalAssignmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ClusterPrincipalAssignmentImpl((ClusterPrincipalAssignmentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ClusterPrincipalAssignment get(String resourceGroupName, String clusterName, String principalAssignmentName) {
        ClusterPrincipalAssignmentInner inner = this.serviceClient().get(resourceGroupName, clusterName, principalAssignmentName);
        if (inner != null) {
            return new ClusterPrincipalAssignmentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String principalAssignmentName) {
        this.serviceClient().delete(resourceGroupName, clusterName, principalAssignmentName);
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String principalAssignmentName, Context context) {
        this.serviceClient().delete(resourceGroupName, clusterName, principalAssignmentName, context);
    }

    @Override
    public PagedIterable<ClusterPrincipalAssignment> list(String resourceGroupName, String clusterName) {
        PagedIterable<ClusterPrincipalAssignmentInner> inner = this.serviceClient().list(resourceGroupName, clusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterPrincipalAssignmentImpl((ClusterPrincipalAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ClusterPrincipalAssignment> list(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<ClusterPrincipalAssignmentInner> inner = this.serviceClient().list(resourceGroupName, clusterName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterPrincipalAssignmentImpl((ClusterPrincipalAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public ClusterPrincipalAssignment getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String principalAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "principalAssignments");
        if (principalAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'principalAssignments'.", id)));
        }
        return (ClusterPrincipalAssignment)this.getWithResponse(resourceGroupName, clusterName, principalAssignmentName, Context.NONE).getValue();
    }

    @Override
    public Response<ClusterPrincipalAssignment> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String principalAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "principalAssignments");
        if (principalAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'principalAssignments'.", id)));
        }
        return this.getWithResponse(resourceGroupName, clusterName, principalAssignmentName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String principalAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "principalAssignments");
        if (principalAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'principalAssignments'.", id)));
        }
        this.delete(resourceGroupName, clusterName, principalAssignmentName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String principalAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "principalAssignments");
        if (principalAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'principalAssignments'.", id)));
        }
        this.delete(resourceGroupName, clusterName, principalAssignmentName, context);
    }

    private ClusterPrincipalAssignmentsClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterPrincipalAssignmentImpl define(String name) {
        return new ClusterPrincipalAssignmentImpl(name, this.manager());
    }
}

