/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.kusto.fluent.models.AttachedDatabaseConfigurationInner;
import com.azure.resourcemanager.kusto.models.DefaultPrincipalsModificationKind;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.TableLevelSharingProperties;
import java.util.List;

public interface AttachedDatabaseConfiguration {
    public String id();

    public String name();

    public String type();

    public String location();

    public ProvisioningState provisioningState();

    public String databaseName();

    public String clusterResourceId();

    public List<String> attachedDatabaseNames();

    public DefaultPrincipalsModificationKind defaultPrincipalsModificationKind();

    public TableLevelSharingProperties tableLevelSharingProperties();

    public String databaseNameOverride();

    public String databaseNamePrefix();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public AttachedDatabaseConfigurationInner innerModel();

    public Update update();

    public AttachedDatabaseConfiguration refresh();

    public AttachedDatabaseConfiguration refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDatabaseNamePrefix {
            public Update withDatabaseNamePrefix(String var1);
        }

        public static interface WithDatabaseNameOverride {
            public Update withDatabaseNameOverride(String var1);
        }

        public static interface WithTableLevelSharingProperties {
            public Update withTableLevelSharingProperties(TableLevelSharingProperties var1);
        }

        public static interface WithDefaultPrincipalsModificationKind {
            public Update withDefaultPrincipalsModificationKind(DefaultPrincipalsModificationKind var1);
        }

        public static interface WithClusterResourceId {
            public Update withClusterResourceId(String var1);
        }

        public static interface WithDatabaseName {
            public Update withDatabaseName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithDatabaseName,
    UpdateStages.WithClusterResourceId,
    UpdateStages.WithDefaultPrincipalsModificationKind,
    UpdateStages.WithTableLevelSharingProperties,
    UpdateStages.WithDatabaseNameOverride,
    UpdateStages.WithDatabaseNamePrefix {
        public AttachedDatabaseConfiguration apply();

        public AttachedDatabaseConfiguration apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDatabaseNamePrefix {
            public WithCreate withDatabaseNamePrefix(String var1);
        }

        public static interface WithDatabaseNameOverride {
            public WithCreate withDatabaseNameOverride(String var1);
        }

        public static interface WithTableLevelSharingProperties {
            public WithCreate withTableLevelSharingProperties(TableLevelSharingProperties var1);
        }

        public static interface WithDefaultPrincipalsModificationKind {
            public WithCreate withDefaultPrincipalsModificationKind(DefaultPrincipalsModificationKind var1);
        }

        public static interface WithClusterResourceId {
            public WithCreate withClusterResourceId(String var1);
        }

        public static interface WithDatabaseName {
            public WithCreate withDatabaseName(String var1);
        }

        public static interface WithLocation {
            public WithCreate withRegion(Region var1);

            public WithCreate withRegion(String var1);
        }

        public static interface WithCreate
        extends WithLocation,
        WithDatabaseName,
        WithClusterResourceId,
        WithDefaultPrincipalsModificationKind,
        WithTableLevelSharingProperties,
        WithDatabaseNameOverride,
        WithDatabaseNamePrefix {
            public AttachedDatabaseConfiguration create();

            public AttachedDatabaseConfiguration create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingCluster(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

