/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.AzureScaleType;
import java.io.IOException;

public final class AzureCapacity
implements JsonSerializable<AzureCapacity> {
    private AzureScaleType scaleType;
    private int minimum;
    private int maximum;
    private int defaultProperty;
    private static final ClientLogger LOGGER = new ClientLogger(AzureCapacity.class);

    public AzureScaleType scaleType() {
        return this.scaleType;
    }

    public AzureCapacity withScaleType(AzureScaleType scaleType) {
        this.scaleType = scaleType;
        return this;
    }

    public int minimum() {
        return this.minimum;
    }

    public AzureCapacity withMinimum(int minimum) {
        this.minimum = minimum;
        return this;
    }

    public int maximum() {
        return this.maximum;
    }

    public AzureCapacity withMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    public int defaultProperty() {
        return this.defaultProperty;
    }

    public AzureCapacity withDefaultProperty(int defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    public void validate() {
        if (this.scaleType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scaleType in model AzureCapacity"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scaleType", this.scaleType == null ? null : this.scaleType.toString());
        jsonWriter.writeIntField("minimum", this.minimum);
        jsonWriter.writeIntField("maximum", this.maximum);
        jsonWriter.writeIntField("default", this.defaultProperty);
        return jsonWriter.writeEndObject();
    }

    public static AzureCapacity fromJson(JsonReader jsonReader) throws IOException {
        return (AzureCapacity)jsonReader.readObject(reader -> {
            AzureCapacity deserializedAzureCapacity = new AzureCapacity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scaleType".equals(fieldName)) {
                    deserializedAzureCapacity.scaleType = AzureScaleType.fromString(reader.getString());
                    continue;
                }
                if ("minimum".equals(fieldName)) {
                    deserializedAzureCapacity.minimum = reader.getInt();
                    continue;
                }
                if ("maximum".equals(fieldName)) {
                    deserializedAzureCapacity.maximum = reader.getInt();
                    continue;
                }
                if ("default".equals(fieldName)) {
                    deserializedAzureCapacity.defaultProperty = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureCapacity;
        });
    }
}

