/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.AzureSkuName;
import com.azure.resourcemanager.kusto.models.AzureSkuTier;
import java.io.IOException;

public final class AzureSku
implements JsonSerializable<AzureSku> {
    private AzureSkuName name;
    private Integer capacity;
    private AzureSkuTier tier;
    private static final ClientLogger LOGGER = new ClientLogger(AzureSku.class);

    public AzureSkuName name() {
        return this.name;
    }

    public AzureSku withName(AzureSkuName name) {
        this.name = name;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public AzureSku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public AzureSkuTier tier() {
        return this.tier;
    }

    public AzureSku withTier(AzureSkuTier tier) {
        this.tier = tier;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model AzureSku"));
        }
        if (this.tier() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tier in model AzureSku"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static AzureSku fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSku)jsonReader.readObject(reader -> {
            AzureSku deserializedAzureSku = new AzureSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureSku.name = AzureSkuName.fromString(reader.getString());
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedAzureSku.tier = AzureSkuTier.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedAzureSku.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureSku;
        });
    }
}

