/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.TableLevelSharingProperties;
import java.io.IOException;

public final class DatabaseInviteFollowerRequest
implements JsonSerializable<DatabaseInviteFollowerRequest> {
    private String inviteeEmail;
    private TableLevelSharingProperties tableLevelSharingProperties;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseInviteFollowerRequest.class);

    public String inviteeEmail() {
        return this.inviteeEmail;
    }

    public DatabaseInviteFollowerRequest withInviteeEmail(String inviteeEmail) {
        this.inviteeEmail = inviteeEmail;
        return this;
    }

    public TableLevelSharingProperties tableLevelSharingProperties() {
        return this.tableLevelSharingProperties;
    }

    public DatabaseInviteFollowerRequest withTableLevelSharingProperties(TableLevelSharingProperties tableLevelSharingProperties) {
        this.tableLevelSharingProperties = tableLevelSharingProperties;
        return this;
    }

    public void validate() {
        if (this.inviteeEmail() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property inviteeEmail in model DatabaseInviteFollowerRequest"));
        }
        if (this.tableLevelSharingProperties() != null) {
            this.tableLevelSharingProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("inviteeEmail", this.inviteeEmail);
        jsonWriter.writeJsonField("tableLevelSharingProperties", (JsonSerializable)this.tableLevelSharingProperties);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseInviteFollowerRequest fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseInviteFollowerRequest)jsonReader.readObject(reader -> {
            DatabaseInviteFollowerRequest deserializedDatabaseInviteFollowerRequest = new DatabaseInviteFollowerRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inviteeEmail".equals(fieldName)) {
                    deserializedDatabaseInviteFollowerRequest.inviteeEmail = reader.getString();
                    continue;
                }
                if ("tableLevelSharingProperties".equals(fieldName)) {
                    deserializedDatabaseInviteFollowerRequest.tableLevelSharingProperties = TableLevelSharingProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseInviteFollowerRequest;
        });
    }
}

