/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.DatabaseInner;
import java.io.IOException;
import java.util.List;

public final class DatabaseListResult
implements JsonSerializable<DatabaseListResult> {
    private String nextLink;
    private List<DatabaseInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public DatabaseListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<DatabaseInner> value() {
        return this.value;
    }

    public DatabaseListResult withValue(List<DatabaseInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DatabaseListResult fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseListResult)jsonReader.readObject(reader -> {
            DatabaseListResult deserializedDatabaseListResult = new DatabaseListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedDatabaseListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDatabaseListResult.value = value = reader.readArray(reader1 -> DatabaseInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseListResult;
        });
    }
}

