/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.DataConnectionInner;
import com.azure.resourcemanager.kusto.fluent.models.EventHubConnectionProperties;
import com.azure.resourcemanager.kusto.models.Compression;
import com.azure.resourcemanager.kusto.models.DataConnectionKind;
import com.azure.resourcemanager.kusto.models.DatabaseRouting;
import com.azure.resourcemanager.kusto.models.EventHubDataFormat;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class EventHubDataConnection
extends DataConnectionInner {
    private DataConnectionKind kind = DataConnectionKind.EVENT_HUB;
    private EventHubConnectionProperties innerProperties;
    private String type;
    private String name;
    private String id;

    @Override
    public DataConnectionKind kind() {
        return this.kind;
    }

    private EventHubConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public EventHubDataConnection withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public String eventHubResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().eventHubResourceId();
    }

    public EventHubDataConnection withEventHubResourceId(String eventHubResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withEventHubResourceId(eventHubResourceId);
        return this;
    }

    public String consumerGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().consumerGroup();
    }

    public EventHubDataConnection withConsumerGroup(String consumerGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withConsumerGroup(consumerGroup);
        return this;
    }

    public String tableName() {
        return this.innerProperties() == null ? null : this.innerProperties().tableName();
    }

    public EventHubDataConnection withTableName(String tableName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withTableName(tableName);
        return this;
    }

    public String mappingRuleName() {
        return this.innerProperties() == null ? null : this.innerProperties().mappingRuleName();
    }

    public EventHubDataConnection withMappingRuleName(String mappingRuleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withMappingRuleName(mappingRuleName);
        return this;
    }

    public EventHubDataFormat dataFormat() {
        return this.innerProperties() == null ? null : this.innerProperties().dataFormat();
    }

    public EventHubDataConnection withDataFormat(EventHubDataFormat dataFormat) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withDataFormat(dataFormat);
        return this;
    }

    public List<String> eventSystemProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().eventSystemProperties();
    }

    public EventHubDataConnection withEventSystemProperties(List<String> eventSystemProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withEventSystemProperties(eventSystemProperties);
        return this;
    }

    public Compression compression() {
        return this.innerProperties() == null ? null : this.innerProperties().compression();
    }

    public EventHubDataConnection withCompression(Compression compression) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withCompression(compression);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String managedIdentityResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedIdentityResourceId();
    }

    public EventHubDataConnection withManagedIdentityResourceId(String managedIdentityResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withManagedIdentityResourceId(managedIdentityResourceId);
        return this;
    }

    public String managedIdentityObjectId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedIdentityObjectId();
    }

    public DatabaseRouting databaseRouting() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseRouting();
    }

    public EventHubDataConnection withDatabaseRouting(DatabaseRouting databaseRouting) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withDatabaseRouting(databaseRouting);
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.innerProperties() == null ? null : this.innerProperties().retrievalStartDate();
    }

    public EventHubDataConnection withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withRetrievalStartDate(retrievalStartDate);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static EventHubDataConnection fromJson(JsonReader jsonReader) throws IOException {
        return (EventHubDataConnection)((Object)jsonReader.readObject(reader -> {
            EventHubDataConnection deserializedEventHubDataConnection = new EventHubDataConnection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEventHubDataConnection.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedEventHubDataConnection.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEventHubDataConnection.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedEventHubDataConnection.withLocation(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedEventHubDataConnection.kind = DataConnectionKind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedEventHubDataConnection.innerProperties = EventHubConnectionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventHubDataConnection;
        }));
    }
}

