/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.DatabaseInner;
import com.azure.resourcemanager.kusto.fluent.models.ReadOnlyFollowingDatabaseProperties;
import com.azure.resourcemanager.kusto.models.DatabaseShareOrigin;
import com.azure.resourcemanager.kusto.models.DatabaseStatistics;
import com.azure.resourcemanager.kusto.models.Kind;
import com.azure.resourcemanager.kusto.models.PrincipalsModificationKind;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.SuspensionDetails;
import com.azure.resourcemanager.kusto.models.TableLevelSharingProperties;
import java.io.IOException;
import java.time.Duration;

public final class ReadOnlyFollowingDatabase
extends DatabaseInner {
    private Kind kind = Kind.READ_ONLY_FOLLOWING;
    private ReadOnlyFollowingDatabaseProperties innerProperties;
    private String type;
    private String name;
    private String id;

    @Override
    public Kind kind() {
        return this.kind;
    }

    private ReadOnlyFollowingDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ReadOnlyFollowingDatabase withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Duration softDeletePeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().softDeletePeriod();
    }

    public Duration hotCachePeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().hotCachePeriod();
    }

    public ReadOnlyFollowingDatabase withHotCachePeriod(Duration hotCachePeriod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReadOnlyFollowingDatabaseProperties();
        }
        this.innerProperties().withHotCachePeriod(hotCachePeriod);
        return this;
    }

    public DatabaseStatistics statistics() {
        return this.innerProperties() == null ? null : this.innerProperties().statistics();
    }

    public String leaderClusterResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().leaderClusterResourceId();
    }

    public String attachedDatabaseConfigurationName() {
        return this.innerProperties() == null ? null : this.innerProperties().attachedDatabaseConfigurationName();
    }

    public PrincipalsModificationKind principalsModificationKind() {
        return this.innerProperties() == null ? null : this.innerProperties().principalsModificationKind();
    }

    public TableLevelSharingProperties tableLevelSharingProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().tableLevelSharingProperties();
    }

    public String originalDatabaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().originalDatabaseName();
    }

    public DatabaseShareOrigin databaseShareOrigin() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseShareOrigin();
    }

    public SuspensionDetails suspensionDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().suspensionDetails();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ReadOnlyFollowingDatabase fromJson(JsonReader jsonReader) throws IOException {
        return (ReadOnlyFollowingDatabase)((Object)jsonReader.readObject(reader -> {
            ReadOnlyFollowingDatabase deserializedReadOnlyFollowingDatabase = new ReadOnlyFollowingDatabase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabase.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabase.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabase.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabase.withLocation(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabase.kind = Kind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedReadOnlyFollowingDatabase.innerProperties = ReadOnlyFollowingDatabaseProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReadOnlyFollowingDatabase;
        }));
    }
}

