/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.DatabaseInner;
import com.azure.resourcemanager.kusto.fluent.models.ReadWriteDatabaseProperties;
import com.azure.resourcemanager.kusto.models.DatabaseStatistics;
import com.azure.resourcemanager.kusto.models.KeyVaultProperties;
import com.azure.resourcemanager.kusto.models.Kind;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.SuspensionDetails;
import java.io.IOException;
import java.time.Duration;

public final class ReadWriteDatabase
extends DatabaseInner {
    private Kind kind = Kind.READ_WRITE;
    private ReadWriteDatabaseProperties innerProperties;
    private String type;
    private String name;
    private String id;

    @Override
    public Kind kind() {
        return this.kind;
    }

    private ReadWriteDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ReadWriteDatabase withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Duration softDeletePeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().softDeletePeriod();
    }

    public ReadWriteDatabase withSoftDeletePeriod(Duration softDeletePeriod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReadWriteDatabaseProperties();
        }
        this.innerProperties().withSoftDeletePeriod(softDeletePeriod);
        return this;
    }

    public Duration hotCachePeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().hotCachePeriod();
    }

    public ReadWriteDatabase withHotCachePeriod(Duration hotCachePeriod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReadWriteDatabaseProperties();
        }
        this.innerProperties().withHotCachePeriod(hotCachePeriod);
        return this;
    }

    public DatabaseStatistics statistics() {
        return this.innerProperties() == null ? null : this.innerProperties().statistics();
    }

    public Boolean isFollowed() {
        return this.innerProperties() == null ? null : this.innerProperties().isFollowed();
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultProperties();
    }

    public ReadWriteDatabase withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReadWriteDatabaseProperties();
        }
        this.innerProperties().withKeyVaultProperties(keyVaultProperties);
        return this;
    }

    public SuspensionDetails suspensionDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().suspensionDetails();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ReadWriteDatabase fromJson(JsonReader jsonReader) throws IOException {
        return (ReadWriteDatabase)((Object)jsonReader.readObject(reader -> {
            ReadWriteDatabase deserializedReadWriteDatabase = new ReadWriteDatabase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedReadWriteDatabase.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedReadWriteDatabase.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedReadWriteDatabase.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedReadWriteDatabase.withLocation(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedReadWriteDatabase.kind = Kind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedReadWriteDatabase.innerProperties = ReadWriteDatabaseProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReadWriteDatabase;
        }));
    }
}

