/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.ResourceSkuZoneDetails;
import java.io.IOException;
import java.util.List;

public final class SkuLocationInfoItem
implements JsonSerializable<SkuLocationInfoItem> {
    private String location;
    private List<String> zones;
    private List<ResourceSkuZoneDetails> zoneDetails;
    private static final ClientLogger LOGGER = new ClientLogger(SkuLocationInfoItem.class);

    public String location() {
        return this.location;
    }

    public SkuLocationInfoItem withLocation(String location) {
        this.location = location;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public SkuLocationInfoItem withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public List<ResourceSkuZoneDetails> zoneDetails() {
        return this.zoneDetails;
    }

    public SkuLocationInfoItem withZoneDetails(List<ResourceSkuZoneDetails> zoneDetails) {
        this.zoneDetails = zoneDetails;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model SkuLocationInfoItem"));
        }
        if (this.zoneDetails() != null) {
            this.zoneDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("zoneDetails", this.zoneDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SkuLocationInfoItem fromJson(JsonReader jsonReader) throws IOException {
        return (SkuLocationInfoItem)jsonReader.readObject(reader -> {
            SkuLocationInfoItem deserializedSkuLocationInfoItem = new SkuLocationInfoItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedSkuLocationInfoItem.location = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedSkuLocationInfoItem.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("zoneDetails".equals(fieldName)) {
                    List zoneDetails;
                    deserializedSkuLocationInfoItem.zoneDetails = zoneDetails = reader.readArray(reader1 -> ResourceSkuZoneDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuLocationInfoItem;
        });
    }
}

