/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.models.DataSourceInner;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.DataSource;
import com.azure.resourcemanager.loganalytics.models.DataSourceKind;
import java.util.Collections;
import java.util.Map;

public final class DataSourceImpl
implements DataSource,
DataSource.Definition,
DataSource.Update {
    private DataSourceInner innerObject;
    private final LogAnalyticsManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private String dataSourceName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Object properties() {
        return this.innerModel().properties();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public DataSourceKind kind() {
        return this.innerModel().kind();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DataSourceInner innerModel() {
        return this.innerObject;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public DataSourceImpl withExistingWorkspace(String resourceGroupName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public DataSource create() {
        this.innerObject = (DataSourceInner)((Object)this.serviceManager.serviceClient().getDataSources().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DataSource create(Context context) {
        this.innerObject = (DataSourceInner)((Object)this.serviceManager.serviceClient().getDataSources().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceName, this.innerModel(), context).getValue());
        return this;
    }

    DataSourceImpl(String name, LogAnalyticsManager serviceManager) {
        this.innerObject = new DataSourceInner();
        this.serviceManager = serviceManager;
        this.dataSourceName = name;
    }

    @Override
    public DataSourceImpl update() {
        return this;
    }

    @Override
    public DataSource apply() {
        this.innerObject = (DataSourceInner)((Object)this.serviceManager.serviceClient().getDataSources().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DataSource apply(Context context) {
        this.innerObject = (DataSourceInner)((Object)this.serviceManager.serviceClient().getDataSources().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceName, this.innerModel(), context).getValue());
        return this;
    }

    DataSourceImpl(DataSourceInner innerObject, LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourcegroups");
        this.workspaceName = Utils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.dataSourceName = Utils.getValueFromIdByName(innerObject.id(), "dataSources");
    }

    @Override
    public DataSource refresh() {
        this.innerObject = (DataSourceInner)((Object)this.serviceManager.serviceClient().getDataSources().getWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DataSource refresh(Context context) {
        this.innerObject = (DataSourceInner)((Object)this.serviceManager.serviceClient().getDataSources().getWithResponse(this.resourceGroupName, this.workspaceName, this.dataSourceName, context).getValue());
        return this;
    }

    @Override
    public DataSourceImpl withProperties(Object properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public DataSourceImpl withKind(DataSourceKind kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public DataSourceImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    @Override
    public DataSourceImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }
}

