/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.SchemasClient;
import com.azure.resourcemanager.loganalytics.fluent.models.SearchGetSchemaResponseInner;
import com.azure.resourcemanager.loganalytics.implementation.SearchGetSchemaResponseImpl;
import com.azure.resourcemanager.loganalytics.models.Schemas;
import com.azure.resourcemanager.loganalytics.models.SearchGetSchemaResponse;

public final class SchemasImpl
implements Schemas {
    private static final ClientLogger LOGGER = new ClientLogger(SchemasImpl.class);
    private final SchemasClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public SchemasImpl(SchemasClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SearchGetSchemaResponse> getWithResponse(String resourceGroupName, String workspaceName, Context context) {
        Response<SearchGetSchemaResponseInner> inner = this.serviceClient().getWithResponse(resourceGroupName, workspaceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SearchGetSchemaResponseImpl((SearchGetSchemaResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SearchGetSchemaResponse get(String resourceGroupName, String workspaceName) {
        SearchGetSchemaResponseInner inner = this.serviceClient().get(resourceGroupName, workspaceName);
        if (inner != null) {
            return new SearchGetSchemaResponseImpl(inner, this.manager());
        }
        return null;
    }

    private SchemasClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }
}

