/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.loganalytics.fluent.UsagesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.UsageMetricInner;
import com.azure.resourcemanager.loganalytics.implementation.OperationalInsightsManagementClientImpl;
import com.azure.resourcemanager.loganalytics.models.WorkspaceListUsagesResult;
import reactor.core.publisher.Mono;

public final class UsagesClientImpl
implements UsagesClient {
    private final UsagesService service;
    private final OperationalInsightsManagementClientImpl client;

    UsagesClientImpl(OperationalInsightsManagementClientImpl client) {
        this.service = (UsagesService)RestProxy.create(UsagesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UsageMetricInner>> listSinglePageAsync(String resourceGroupName, String workspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, workspaceName, "2020-08-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkspaceListUsagesResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UsageMetricInner>> listSinglePageAsync(String resourceGroupName, String workspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, workspaceName, "2020-08-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkspaceListUsagesResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<UsageMetricInner> listAsync(String resourceGroupName, String workspaceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, workspaceName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<UsageMetricInner> listAsync(String resourceGroupName, String workspaceName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, workspaceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<UsageMetricInner> list(String resourceGroupName, String workspaceName) {
        return new PagedIterable(this.listAsync(resourceGroupName, workspaceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<UsageMetricInner> list(String resourceGroupName, String workspaceName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, workspaceName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="OperationalInsightsM")
    public static interface UsagesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/usages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkspaceListUsagesResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="workspaceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

