/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.UsagesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.UsageMetricInner;
import com.azure.resourcemanager.loganalytics.implementation.UsageMetricImpl;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.UsageMetric;
import com.azure.resourcemanager.loganalytics.models.Usages;

public final class UsagesImpl
implements Usages {
    private static final ClientLogger LOGGER = new ClientLogger(UsagesImpl.class);
    private final UsagesClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public UsagesImpl(UsagesClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<UsageMetric> list(String resourceGroupName, String workspaceName) {
        PagedIterable<UsageMetricInner> inner = this.serviceClient().list(resourceGroupName, workspaceName);
        return Utils.mapPage(inner, inner1 -> new UsageMetricImpl((UsageMetricInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<UsageMetric> list(String resourceGroupName, String workspaceName, Context context) {
        PagedIterable<UsageMetricInner> inner = this.serviceClient().list(resourceGroupName, workspaceName, context);
        return Utils.mapPage(inner, inner1 -> new UsageMetricImpl((UsageMetricInner)inner1, this.manager()));
    }

    private UsagesClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }
}

