/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.ClusterInner;
import com.azure.resourcemanager.loganalytics.models.AssociatedWorkspace;
import com.azure.resourcemanager.loganalytics.models.BillingType;
import com.azure.resourcemanager.loganalytics.models.CapacityReservationProperties;
import com.azure.resourcemanager.loganalytics.models.ClusterEntityStatus;
import com.azure.resourcemanager.loganalytics.models.ClusterSku;
import com.azure.resourcemanager.loganalytics.models.Identity;
import com.azure.resourcemanager.loganalytics.models.KeyVaultProperties;
import java.util.List;
import java.util.Map;

public interface Cluster {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public Identity identity();

    public ClusterSku sku();

    public String clusterId();

    public ClusterEntityStatus provisioningState();

    public Boolean isDoubleEncryptionEnabled();

    public Boolean isAvailabilityZonesEnabled();

    public BillingType billingType();

    public KeyVaultProperties keyVaultProperties();

    public String lastModifiedDate();

    public String createdDate();

    public List<AssociatedWorkspace> associatedWorkspaces();

    public CapacityReservationProperties capacityReservationProperties();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ClusterInner innerModel();

    public Update update();

    public Cluster refresh();

    public Cluster refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithBillingType {
            public Update withBillingType(BillingType var1);
        }

        public static interface WithKeyVaultProperties {
            public Update withKeyVaultProperties(KeyVaultProperties var1);
        }

        public static interface WithSku {
            public Update withSku(ClusterSku var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(Identity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithSku,
    UpdateStages.WithKeyVaultProperties,
    UpdateStages.WithBillingType {
        public Cluster apply();

        public Cluster apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithCapacityReservationProperties {
            public WithCreate withCapacityReservationProperties(CapacityReservationProperties var1);
        }

        public static interface WithAssociatedWorkspaces {
            public WithCreate withAssociatedWorkspaces(List<AssociatedWorkspace> var1);
        }

        public static interface WithKeyVaultProperties {
            public WithCreate withKeyVaultProperties(KeyVaultProperties var1);
        }

        public static interface WithBillingType {
            public WithCreate withBillingType(BillingType var1);
        }

        public static interface WithIsAvailabilityZonesEnabled {
            public WithCreate withIsAvailabilityZonesEnabled(Boolean var1);
        }

        public static interface WithIsDoubleEncryptionEnabled {
            public WithCreate withIsDoubleEncryptionEnabled(Boolean var1);
        }

        public static interface WithSku {
            public WithCreate withSku(ClusterSku var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(Identity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithSku,
        WithIsDoubleEncryptionEnabled,
        WithIsAvailabilityZonesEnabled,
        WithBillingType,
        WithKeyVaultProperties,
        WithAssociatedWorkspaces,
        WithCapacityReservationProperties {
            public Cluster create();

            public Cluster create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

