/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.Action;
import com.azure.resourcemanager.monitor.models.Enabled;
import com.azure.resourcemanager.monitor.models.ProvisioningState;
import com.azure.resourcemanager.monitor.models.Schedule;
import com.azure.resourcemanager.monitor.models.Source;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

@JsonFlatten
public class LogSearchRuleResourceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LogSearchRuleResourceInner.class);
    @JsonProperty(value="properties.createdWithApiVersion", access=JsonProperty.Access.WRITE_ONLY)
    private String createdWithApiVersion;
    @JsonProperty(value="properties.isLegacyLogAnalyticsRule", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isLegacyLogAnalyticsRule;
    @JsonProperty(value="properties.description")
    private String description;
    @JsonProperty(value="properties.displayName")
    private String displayName;
    @JsonProperty(value="properties.autoMitigate")
    private Boolean autoMitigate;
    @JsonProperty(value="properties.enabled")
    private Enabled enabled;
    @JsonProperty(value="properties.lastUpdatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastUpdatedTime;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.source", required=true)
    private Source source;
    @JsonProperty(value="properties.schedule")
    private Schedule schedule;
    @JsonProperty(value="properties.action", required=true)
    private Action action;
    @JsonProperty(value="kind", access=JsonProperty.Access.WRITE_ONLY)
    private String kind;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;

    public String createdWithApiVersion() {
        return this.createdWithApiVersion;
    }

    public Boolean isLegacyLogAnalyticsRule() {
        return this.isLegacyLogAnalyticsRule;
    }

    public String description() {
        return this.description;
    }

    public LogSearchRuleResourceInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public LogSearchRuleResourceInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Boolean autoMitigate() {
        return this.autoMitigate;
    }

    public LogSearchRuleResourceInner withAutoMitigate(Boolean autoMitigate) {
        this.autoMitigate = autoMitigate;
        return this;
    }

    public Enabled enabled() {
        return this.enabled;
    }

    public LogSearchRuleResourceInner withEnabled(Enabled enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Source source() {
        return this.source;
    }

    public LogSearchRuleResourceInner withSource(Source source) {
        this.source = source;
        return this;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public LogSearchRuleResourceInner withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public Action action() {
        return this.action;
    }

    public LogSearchRuleResourceInner withAction(Action action) {
        this.action = action;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public String etag() {
        return this.etag;
    }

    public LogSearchRuleResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public LogSearchRuleResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property source in model LogSearchRuleResourceInner"));
        }
        this.source().validate();
        if (this.schedule() != null) {
            this.schedule().validate();
        }
        if (this.action() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property action in model LogSearchRuleResourceInner"));
        }
        this.action().validate();
    }
}

