/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleDataSources;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleDestinations;
import com.azure.resourcemanager.monitor.models.DataFlow;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class DataCollectionRule {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DataCollectionRule.class);
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="immutableId", access=JsonProperty.Access.WRITE_ONLY)
    private String immutableId;
    @JsonProperty(value="dataSources")
    private DataCollectionRuleDataSources dataSources;
    @JsonProperty(value="destinations")
    private DataCollectionRuleDestinations destinations;
    @JsonProperty(value="dataFlows")
    private List<DataFlow> dataFlows;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private KnownDataCollectionRuleProvisioningState provisioningState;

    public String description() {
        return this.description;
    }

    public DataCollectionRule withDescription(String description) {
        this.description = description;
        return this;
    }

    public String immutableId() {
        return this.immutableId;
    }

    public DataCollectionRuleDataSources dataSources() {
        return this.dataSources;
    }

    public DataCollectionRule withDataSources(DataCollectionRuleDataSources dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    public DataCollectionRuleDestinations destinations() {
        return this.destinations;
    }

    public DataCollectionRule withDestinations(DataCollectionRuleDestinations destinations) {
        this.destinations = destinations;
        return this;
    }

    public List<DataFlow> dataFlows() {
        return this.dataFlows;
    }

    public DataCollectionRule withDataFlows(List<DataFlow> dataFlows) {
        this.dataFlows = dataFlows;
        return this;
    }

    public KnownDataCollectionRuleProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.dataSources() != null) {
            this.dataSources().validate();
        }
        if (this.destinations() != null) {
            this.destinations().validate();
        }
        if (this.dataFlows() != null) {
            this.dataFlows().forEach(e -> e.validate());
        }
    }
}

