/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.ExtensionDataSource;
import com.azure.resourcemanager.monitor.models.PerfCounterDataSource;
import com.azure.resourcemanager.monitor.models.SyslogDataSource;
import com.azure.resourcemanager.monitor.models.WindowsEventLogDataSource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class DataSourcesSpec {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DataSourcesSpec.class);
    @JsonProperty(value="performanceCounters")
    private List<PerfCounterDataSource> performanceCounters;
    @JsonProperty(value="windowsEventLogs")
    private List<WindowsEventLogDataSource> windowsEventLogs;
    @JsonProperty(value="syslog")
    private List<SyslogDataSource> syslog;
    @JsonProperty(value="extensions")
    private List<ExtensionDataSource> extensions;

    public List<PerfCounterDataSource> performanceCounters() {
        return this.performanceCounters;
    }

    public DataSourcesSpec withPerformanceCounters(List<PerfCounterDataSource> performanceCounters) {
        this.performanceCounters = performanceCounters;
        return this;
    }

    public List<WindowsEventLogDataSource> windowsEventLogs() {
        return this.windowsEventLogs;
    }

    public DataSourcesSpec withWindowsEventLogs(List<WindowsEventLogDataSource> windowsEventLogs) {
        this.windowsEventLogs = windowsEventLogs;
        return this;
    }

    public List<SyslogDataSource> syslog() {
        return this.syslog;
    }

    public DataSourcesSpec withSyslog(List<SyslogDataSource> syslog) {
        this.syslog = syslog;
        return this;
    }

    public List<ExtensionDataSource> extensions() {
        return this.extensions;
    }

    public DataSourcesSpec withExtensions(List<ExtensionDataSource> extensions) {
        this.extensions = extensions;
        return this;
    }

    public void validate() {
        if (this.performanceCounters() != null) {
            this.performanceCounters().forEach(e -> e.validate());
        }
        if (this.windowsEventLogs() != null) {
            this.windowsEventLogs().forEach(e -> e.validate());
        }
        if (this.syslog() != null) {
            this.syslog().forEach(e -> e.validate());
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
    }
}

