/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ArmRoleReceiver
implements JsonSerializable<ArmRoleReceiver> {
    private String name;
    private String roleId;
    private Boolean useCommonAlertSchema;
    private static final ClientLogger LOGGER = new ClientLogger(ArmRoleReceiver.class);

    public String name() {
        return this.name;
    }

    public ArmRoleReceiver withName(String name) {
        this.name = name;
        return this;
    }

    public String roleId() {
        return this.roleId;
    }

    public ArmRoleReceiver withRoleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    public Boolean useCommonAlertSchema() {
        return this.useCommonAlertSchema;
    }

    public ArmRoleReceiver withUseCommonAlertSchema(Boolean useCommonAlertSchema) {
        this.useCommonAlertSchema = useCommonAlertSchema;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ArmRoleReceiver"));
        }
        if (this.roleId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property roleId in model ArmRoleReceiver"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("roleId", this.roleId);
        jsonWriter.writeBooleanField("useCommonAlertSchema", this.useCommonAlertSchema);
        return jsonWriter.writeEndObject();
    }

    public static ArmRoleReceiver fromJson(JsonReader jsonReader) throws IOException {
        return (ArmRoleReceiver)jsonReader.readObject(reader -> {
            ArmRoleReceiver deserializedArmRoleReceiver = new ArmRoleReceiver();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedArmRoleReceiver.name = reader.getString();
                    continue;
                }
                if ("roleId".equals(fieldName)) {
                    deserializedArmRoleReceiver.roleId = reader.getString();
                    continue;
                }
                if ("useCommonAlertSchema".equals(fieldName)) {
                    deserializedArmRoleReceiver.useCommonAlertSchema = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedArmRoleReceiver;
        });
    }
}

