/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.DataCollectionEndpointConfigurationAccess;
import com.azure.resourcemanager.monitor.models.DataCollectionEndpointLogsIngestion;
import com.azure.resourcemanager.monitor.models.DataCollectionEndpointNetworkAcls;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionEndpointProvisioningState;
import java.io.IOException;

public class DataCollectionEndpoint
implements JsonSerializable<DataCollectionEndpoint> {
    private String description;
    private String immutableId;
    private DataCollectionEndpointConfigurationAccess configurationAccess;
    private DataCollectionEndpointLogsIngestion logsIngestion;
    private DataCollectionEndpointNetworkAcls networkAcls;
    private KnownDataCollectionEndpointProvisioningState provisioningState;

    public String description() {
        return this.description;
    }

    public DataCollectionEndpoint withDescription(String description) {
        this.description = description;
        return this;
    }

    public String immutableId() {
        return this.immutableId;
    }

    public DataCollectionEndpoint withImmutableId(String immutableId) {
        this.immutableId = immutableId;
        return this;
    }

    public DataCollectionEndpointConfigurationAccess configurationAccess() {
        return this.configurationAccess;
    }

    public DataCollectionEndpoint withConfigurationAccess(DataCollectionEndpointConfigurationAccess configurationAccess) {
        this.configurationAccess = configurationAccess;
        return this;
    }

    public DataCollectionEndpointLogsIngestion logsIngestion() {
        return this.logsIngestion;
    }

    public DataCollectionEndpoint withLogsIngestion(DataCollectionEndpointLogsIngestion logsIngestion) {
        this.logsIngestion = logsIngestion;
        return this;
    }

    public DataCollectionEndpointNetworkAcls networkAcls() {
        return this.networkAcls;
    }

    public DataCollectionEndpoint withNetworkAcls(DataCollectionEndpointNetworkAcls networkAcls) {
        this.networkAcls = networkAcls;
        return this;
    }

    public KnownDataCollectionEndpointProvisioningState provisioningState() {
        return this.provisioningState;
    }

    DataCollectionEndpoint withProvisioningState(KnownDataCollectionEndpointProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
        if (this.configurationAccess() != null) {
            this.configurationAccess().validate();
        }
        if (this.logsIngestion() != null) {
            this.logsIngestion().validate();
        }
        if (this.networkAcls() != null) {
            this.networkAcls().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("immutableId", this.immutableId);
        jsonWriter.writeJsonField("configurationAccess", (JsonSerializable)this.configurationAccess);
        jsonWriter.writeJsonField("logsIngestion", (JsonSerializable)this.logsIngestion);
        jsonWriter.writeJsonField("networkAcls", (JsonSerializable)this.networkAcls);
        return jsonWriter.writeEndObject();
    }

    public static DataCollectionEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return (DataCollectionEndpoint)jsonReader.readObject(reader -> {
            DataCollectionEndpoint deserializedDataCollectionEndpoint = new DataCollectionEndpoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.description = reader.getString();
                    continue;
                }
                if ("immutableId".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.immutableId = reader.getString();
                    continue;
                }
                if ("configurationAccess".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.configurationAccess = DataCollectionEndpointConfigurationAccess.fromJson(reader);
                    continue;
                }
                if ("logsIngestion".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.logsIngestion = DataCollectionEndpointLogsIngestion.fromJson(reader);
                    continue;
                }
                if ("networkAcls".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.networkAcls = DataCollectionEndpointNetworkAcls.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.provisioningState = KnownDataCollectionEndpointProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataCollectionEndpoint;
        });
    }
}

