/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.RetentionPolicy;
import java.io.IOException;

public final class LogSettings
implements JsonSerializable<LogSettings> {
    private String category;
    private String categoryGroup;
    private boolean enabled;
    private RetentionPolicy retentionPolicy;

    public String category() {
        return this.category;
    }

    public LogSettings withCategory(String category) {
        this.category = category;
        return this;
    }

    public String categoryGroup() {
        return this.categoryGroup;
    }

    public LogSettings withCategoryGroup(String categoryGroup) {
        this.categoryGroup = categoryGroup;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public LogSettings withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    public LogSettings withRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public void validate() {
        if (this.retentionPolicy() != null) {
            this.retentionPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeStringField("categoryGroup", this.categoryGroup);
        jsonWriter.writeJsonField("retentionPolicy", (JsonSerializable)this.retentionPolicy);
        return jsonWriter.writeEndObject();
    }

    public static LogSettings fromJson(JsonReader jsonReader) throws IOException {
        return (LogSettings)jsonReader.readObject(reader -> {
            LogSettings deserializedLogSettings = new LogSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedLogSettings.enabled = reader.getBoolean();
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedLogSettings.category = reader.getString();
                    continue;
                }
                if ("categoryGroup".equals(fieldName)) {
                    deserializedLogSettings.categoryGroup = reader.getString();
                    continue;
                }
                if ("retentionPolicy".equals(fieldName)) {
                    deserializedLogSettings.retentionPolicy = RetentionPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogSettings;
        });
    }
}

