/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class MetricAvailability
implements JsonSerializable<MetricAvailability> {
    private Duration timeGrain;
    private Duration retention;

    public Duration timeGrain() {
        return this.timeGrain;
    }

    public MetricAvailability withTimeGrain(Duration timeGrain) {
        this.timeGrain = timeGrain;
        return this;
    }

    public Duration retention() {
        return this.retention;
    }

    public MetricAvailability withRetention(Duration retention) {
        this.retention = retention;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeGrain", CoreUtils.durationToStringWithDays((Duration)this.timeGrain));
        jsonWriter.writeStringField("retention", CoreUtils.durationToStringWithDays((Duration)this.retention));
        return jsonWriter.writeEndObject();
    }

    public static MetricAvailability fromJson(JsonReader jsonReader) throws IOException {
        return (MetricAvailability)jsonReader.readObject(reader -> {
            MetricAvailability deserializedMetricAvailability = new MetricAvailability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeGrain".equals(fieldName)) {
                    deserializedMetricAvailability.timeGrain = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("retention".equals(fieldName)) {
                    deserializedMetricAvailability.retention = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricAvailability;
        });
    }
}

