/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.DataSourcesSpec;
import com.azure.resourcemanager.monitor.models.ExtensionDataSource;
import com.azure.resourcemanager.monitor.models.IisLogsDataSource;
import com.azure.resourcemanager.monitor.models.LogFilesDataSource;
import com.azure.resourcemanager.monitor.models.PerfCounterDataSource;
import com.azure.resourcemanager.monitor.models.SyslogDataSource;
import com.azure.resourcemanager.monitor.models.WindowsEventLogDataSource;
import java.io.IOException;
import java.util.List;

public final class DataCollectionRuleDataSources
extends DataSourcesSpec {
    @Override
    public DataCollectionRuleDataSources withPerformanceCounters(List<PerfCounterDataSource> performanceCounters) {
        super.withPerformanceCounters(performanceCounters);
        return this;
    }

    @Override
    public DataCollectionRuleDataSources withWindowsEventLogs(List<WindowsEventLogDataSource> windowsEventLogs) {
        super.withWindowsEventLogs(windowsEventLogs);
        return this;
    }

    @Override
    public DataCollectionRuleDataSources withSyslog(List<SyslogDataSource> syslog) {
        super.withSyslog(syslog);
        return this;
    }

    @Override
    public DataCollectionRuleDataSources withExtensions(List<ExtensionDataSource> extensions) {
        super.withExtensions(extensions);
        return this;
    }

    @Override
    public DataCollectionRuleDataSources withLogFiles(List<LogFilesDataSource> logFiles) {
        super.withLogFiles(logFiles);
        return this;
    }

    @Override
    public DataCollectionRuleDataSources withIisLogs(List<IisLogsDataSource> iisLogs) {
        super.withIisLogs(iisLogs);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("performanceCounters", this.performanceCounters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("windowsEventLogs", this.windowsEventLogs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("syslog", this.syslog(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("extensions", this.extensions(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("logFiles", this.logFiles(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("iisLogs", this.iisLogs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DataCollectionRuleDataSources fromJson(JsonReader jsonReader) throws IOException {
        return (DataCollectionRuleDataSources)jsonReader.readObject(reader -> {
            DataCollectionRuleDataSources deserializedDataCollectionRuleDataSources = new DataCollectionRuleDataSources();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("performanceCounters".equals(fieldName)) {
                    List performanceCounters = reader.readArray(reader1 -> PerfCounterDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withPerformanceCounters(performanceCounters);
                    continue;
                }
                if ("windowsEventLogs".equals(fieldName)) {
                    List windowsEventLogs = reader.readArray(reader1 -> WindowsEventLogDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withWindowsEventLogs(windowsEventLogs);
                    continue;
                }
                if ("syslog".equals(fieldName)) {
                    List syslog = reader.readArray(reader1 -> SyslogDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withSyslog(syslog);
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List extensions = reader.readArray(reader1 -> ExtensionDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withExtensions(extensions);
                    continue;
                }
                if ("logFiles".equals(fieldName)) {
                    List logFiles = reader.readArray(reader1 -> LogFilesDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withLogFiles(logFiles);
                    continue;
                }
                if ("iisLogs".equals(fieldName)) {
                    List iisLogs = reader.readArray(reader1 -> IisLogsDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withIisLogs(iisLogs);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataCollectionRuleDataSources;
        });
    }
}

