/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class TimeWindow
implements JsonSerializable<TimeWindow> {
    private String timeZone;
    private OffsetDateTime start;
    private OffsetDateTime end;
    private static final ClientLogger LOGGER = new ClientLogger(TimeWindow.class);

    public String timeZone() {
        return this.timeZone;
    }

    public TimeWindow withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public OffsetDateTime start() {
        return this.start;
    }

    public TimeWindow withStart(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    public OffsetDateTime end() {
        return this.end;
    }

    public TimeWindow withEnd(OffsetDateTime end) {
        this.end = end;
        return this;
    }

    public void validate() {
        if (this.start() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property start in model TimeWindow"));
        }
        if (this.end() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property end in model TimeWindow"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("start", this.start == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.start));
        jsonWriter.writeStringField("end", this.end == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.end));
        jsonWriter.writeStringField("timeZone", this.timeZone);
        return jsonWriter.writeEndObject();
    }

    public static TimeWindow fromJson(JsonReader jsonReader) throws IOException {
        return (TimeWindow)jsonReader.readObject(reader -> {
            TimeWindow deserializedTimeWindow = new TimeWindow();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("start".equals(fieldName)) {
                    deserializedTimeWindow.start = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("end".equals(fieldName)) {
                    deserializedTimeWindow.end = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("timeZone".equals(fieldName)) {
                    deserializedTimeWindow.timeZone = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTimeWindow;
        });
    }
}

