/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.implementation;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.authorization.models.RoleAssignment;
import com.azure.resourcemanager.authorization.utils.RoleAssignmentHelper;
import com.azure.resourcemanager.msi.MsiManager;
import com.azure.resourcemanager.msi.fluent.ManagedServiceIdentityClient;
import com.azure.resourcemanager.msi.fluent.models.IdentityInner;
import com.azure.resourcemanager.msi.models.Identity;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class IdentityImpl
extends GroupableResourceImpl<Identity, IdentityInner, IdentityImpl, MsiManager>
implements Identity,
Identity.Definition,
Identity.Update {
    private RoleAssignmentHelper roleAssignmentHelper;

    public IdentityImpl(String name, IdentityInner innerObject, MsiManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
        this.roleAssignmentHelper = new RoleAssignmentHelper(manager.authorizationManager(), this.taskGroup(), this.idProvider());
    }

    @Override
    public String tenantId() {
        if (((IdentityInner)((Object)this.innerModel())).tenantId() == null) {
            return null;
        }
        return ((IdentityInner)((Object)this.innerModel())).tenantId().toString();
    }

    @Override
    public String principalId() {
        if (((IdentityInner)((Object)this.innerModel())).principalId() == null) {
            return null;
        }
        return ((IdentityInner)((Object)this.innerModel())).principalId().toString();
    }

    @Override
    public String clientId() {
        if (((IdentityInner)((Object)this.innerModel())).clientId() == null) {
            return null;
        }
        return ((IdentityInner)((Object)this.innerModel())).clientId().toString();
    }

    @Override
    public IdentityImpl withAccessTo(com.azure.resourcemanager.resources.fluentcore.arm.models.Resource resource, BuiltInRole role) {
        this.roleAssignmentHelper.withAccessTo(resource.id(), role);
        return this;
    }

    @Override
    public IdentityImpl withAccessTo(String resourceId, BuiltInRole role) {
        this.roleAssignmentHelper.withAccessTo(resourceId, role);
        return this;
    }

    @Override
    public IdentityImpl withAccessToCurrentResourceGroup(BuiltInRole role) {
        this.roleAssignmentHelper.withAccessToCurrentResourceGroup(role);
        return this;
    }

    @Override
    public IdentityImpl withAccessTo(com.azure.resourcemanager.resources.fluentcore.arm.models.Resource resource, String roleDefinitionId) {
        this.roleAssignmentHelper.withAccessTo(resource.id(), roleDefinitionId);
        return this;
    }

    @Override
    public IdentityImpl withAccessTo(String resourceId, String roleDefinitionId) {
        this.roleAssignmentHelper.withAccessTo(resourceId, roleDefinitionId);
        return this;
    }

    @Override
    public IdentityImpl withAccessToCurrentResourceGroup(String roleDefinitionId) {
        this.roleAssignmentHelper.withAccessToCurrentResourceGroup(roleDefinitionId);
        return this;
    }

    @Override
    public IdentityImpl withoutAccess(RoleAssignment access) {
        this.roleAssignmentHelper.withoutAccessTo(access);
        return this;
    }

    @Override
    public IdentityImpl withoutAccessTo(String resourceId, BuiltInRole role) {
        this.roleAssignmentHelper.withoutAccessTo(resourceId, role);
        return this;
    }

    public Mono<Identity> createResourceAsync() {
        return ((ManagedServiceIdentityClient)((MsiManager)this.manager()).serviceClient()).getUserAssignedIdentities().createOrUpdateAsync(this.resourceGroupName(), this.name(), (IdentityInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<IdentityInner> getInnerAsync() {
        return ((ManagedServiceIdentityClient)((MsiManager)this.myManager).serviceClient()).getUserAssignedIdentities().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private RoleAssignmentHelper.IdProvider idProvider() {
        return new RoleAssignmentHelper.IdProvider(){

            public String principalId() {
                Objects.requireNonNull((IdentityInner)((Object)IdentityImpl.this.innerModel()));
                Objects.requireNonNull(((IdentityInner)((Object)IdentityImpl.this.innerModel())).principalId());
                return ((IdentityInner)((Object)IdentityImpl.this.innerModel())).principalId().toString();
            }

            public String resourceId() {
                Objects.requireNonNull((IdentityInner)((Object)IdentityImpl.this.innerModel()));
                Objects.requireNonNull(((IdentityInner)((Object)IdentityImpl.this.innerModel())).id());
                return ((IdentityInner)((Object)IdentityImpl.this.innerModel())).id();
            }
        };
    }
}

