/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringId;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ExpressRouteConnectionProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="expressRouteCircuitPeering", required=true)
    private ExpressRouteCircuitPeeringId expressRouteCircuitPeering;
    @JsonProperty(value="authorizationKey")
    private String authorizationKey;
    @JsonProperty(value="routingWeight")
    private Integer routingWeight;
    @JsonProperty(value="enableInternetSecurity")
    private Boolean enableInternetSecurity;
    @JsonProperty(value="expressRouteGatewayBypass")
    private Boolean expressRouteGatewayBypass;
    @JsonProperty(value="routingConfiguration")
    private RoutingConfiguration routingConfiguration;
    private static final ClientLogger LOGGER = new ClientLogger(ExpressRouteConnectionProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ExpressRouteCircuitPeeringId expressRouteCircuitPeering() {
        return this.expressRouteCircuitPeering;
    }

    public ExpressRouteConnectionProperties withExpressRouteCircuitPeering(ExpressRouteCircuitPeeringId expressRouteCircuitPeering) {
        this.expressRouteCircuitPeering = expressRouteCircuitPeering;
        return this;
    }

    public String authorizationKey() {
        return this.authorizationKey;
    }

    public ExpressRouteConnectionProperties withAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    public Integer routingWeight() {
        return this.routingWeight;
    }

    public ExpressRouteConnectionProperties withRoutingWeight(Integer routingWeight) {
        this.routingWeight = routingWeight;
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    public ExpressRouteConnectionProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    public Boolean expressRouteGatewayBypass() {
        return this.expressRouteGatewayBypass;
    }

    public ExpressRouteConnectionProperties withExpressRouteGatewayBypass(Boolean expressRouteGatewayBypass) {
        this.expressRouteGatewayBypass = expressRouteGatewayBypass;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public ExpressRouteConnectionProperties withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public void validate() {
        if (this.expressRouteCircuitPeering() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property expressRouteCircuitPeering in model ExpressRouteConnectionProperties"));
        }
        this.expressRouteCircuitPeering().validate();
        if (this.routingConfiguration() != null) {
            this.routingConfiguration().validate();
        }
    }
}

