/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.VirtualHubProperties;
import com.azure.resourcemanager.network.fluent.models.VirtualHubRouteTableV2Inner;
import com.azure.resourcemanager.network.models.HubRoutingPreference;
import com.azure.resourcemanager.network.models.PreferredRoutingGateway;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingState;
import com.azure.resourcemanager.network.models.VirtualHubRouteTable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class VirtualHubInner
extends Resource {
    @JsonProperty(value="properties")
    private VirtualHubProperties innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="kind", access=JsonProperty.Access.WRITE_ONLY)
    private String kind;
    @JsonProperty(value="id")
    private String id;

    private VirtualHubProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String kind() {
        return this.kind;
    }

    public String id() {
        return this.id;
    }

    public VirtualHubInner withId(String id) {
        this.id = id;
        return this;
    }

    public VirtualHubInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualHubInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource virtualWan() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualWan();
    }

    public VirtualHubInner withVirtualWan(SubResource virtualWan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withVirtualWan(virtualWan);
        return this;
    }

    public SubResource vpnGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnGateway();
    }

    public VirtualHubInner withVpnGateway(SubResource vpnGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withVpnGateway(vpnGateway);
        return this;
    }

    public SubResource p2SVpnGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().p2SVpnGateway();
    }

    public VirtualHubInner withP2SVpnGateway(SubResource p2SVpnGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withP2SVpnGateway(p2SVpnGateway);
        return this;
    }

    public SubResource expressRouteGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteGateway();
    }

    public VirtualHubInner withExpressRouteGateway(SubResource expressRouteGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withExpressRouteGateway(expressRouteGateway);
        return this;
    }

    public SubResource azureFirewall() {
        return this.innerProperties() == null ? null : this.innerProperties().azureFirewall();
    }

    public VirtualHubInner withAzureFirewall(SubResource azureFirewall) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withAzureFirewall(azureFirewall);
        return this;
    }

    public SubResource securityPartnerProvider() {
        return this.innerProperties() == null ? null : this.innerProperties().securityPartnerProvider();
    }

    public VirtualHubInner withSecurityPartnerProvider(SubResource securityPartnerProvider) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withSecurityPartnerProvider(securityPartnerProvider);
        return this;
    }

    public String addressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefix();
    }

    public VirtualHubInner withAddressPrefix(String addressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withAddressPrefix(addressPrefix);
        return this;
    }

    public VirtualHubRouteTable routeTable() {
        return this.innerProperties() == null ? null : this.innerProperties().routeTable();
    }

    public VirtualHubInner withRouteTable(VirtualHubRouteTable routeTable) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withRouteTable(routeTable);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String securityProviderName() {
        return this.innerProperties() == null ? null : this.innerProperties().securityProviderName();
    }

    public VirtualHubInner withSecurityProviderName(String securityProviderName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withSecurityProviderName(securityProviderName);
        return this;
    }

    public List<VirtualHubRouteTableV2Inner> virtualHubRouteTableV2S() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHubRouteTableV2S();
    }

    public VirtualHubInner withVirtualHubRouteTableV2S(List<VirtualHubRouteTableV2Inner> virtualHubRouteTableV2S) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withVirtualHubRouteTableV2S(virtualHubRouteTableV2S);
        return this;
    }

    public String sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public VirtualHubInner withSku(String sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public RoutingState routingState() {
        return this.innerProperties() == null ? null : this.innerProperties().routingState();
    }

    public List<SubResource> bgpConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpConnections();
    }

    public List<SubResource> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public Long virtualRouterAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualRouterAsn();
    }

    public VirtualHubInner withVirtualRouterAsn(Long virtualRouterAsn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withVirtualRouterAsn(virtualRouterAsn);
        return this;
    }

    public List<String> virtualRouterIps() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualRouterIps();
    }

    public VirtualHubInner withVirtualRouterIps(List<String> virtualRouterIps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withVirtualRouterIps(virtualRouterIps);
        return this;
    }

    public Boolean allowBranchToBranchTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowBranchToBranchTraffic();
    }

    public VirtualHubInner withAllowBranchToBranchTraffic(Boolean allowBranchToBranchTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withAllowBranchToBranchTraffic(allowBranchToBranchTraffic);
        return this;
    }

    public PreferredRoutingGateway preferredRoutingGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().preferredRoutingGateway();
    }

    public VirtualHubInner withPreferredRoutingGateway(PreferredRoutingGateway preferredRoutingGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withPreferredRoutingGateway(preferredRoutingGateway);
        return this;
    }

    public HubRoutingPreference hubRoutingPreference() {
        return this.innerProperties() == null ? null : this.innerProperties().hubRoutingPreference();
    }

    public VirtualHubInner withHubRoutingPreference(HubRoutingPreference hubRoutingPreference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubProperties();
        }
        this.innerProperties().withHubRoutingPreference(hubRoutingPreference);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

