/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ConnectivityGroupItem;
import com.azure.resourcemanager.network.models.ConnectivityTopology;
import com.azure.resourcemanager.network.models.DeleteExistingPeering;
import com.azure.resourcemanager.network.models.Hub;
import com.azure.resourcemanager.network.models.IsGlobal;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ConnectivityConfigurationProperties {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="connectivityTopology", required=true)
    private ConnectivityTopology connectivityTopology;
    @JsonProperty(value="hubs")
    private List<Hub> hubs;
    @JsonProperty(value="isGlobal")
    private IsGlobal isGlobal;
    @JsonProperty(value="appliesToGroups", required=true)
    private List<ConnectivityGroupItem> appliesToGroups;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="deleteExistingPeering")
    private DeleteExistingPeering deleteExistingPeering;
    @JsonProperty(value="resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityConfigurationProperties.class);

    public String description() {
        return this.description;
    }

    public ConnectivityConfigurationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public ConnectivityTopology connectivityTopology() {
        return this.connectivityTopology;
    }

    public ConnectivityConfigurationProperties withConnectivityTopology(ConnectivityTopology connectivityTopology) {
        this.connectivityTopology = connectivityTopology;
        return this;
    }

    public List<Hub> hubs() {
        return this.hubs;
    }

    public ConnectivityConfigurationProperties withHubs(List<Hub> hubs) {
        this.hubs = hubs;
        return this;
    }

    public IsGlobal isGlobal() {
        return this.isGlobal;
    }

    public ConnectivityConfigurationProperties withIsGlobal(IsGlobal isGlobal) {
        this.isGlobal = isGlobal;
        return this;
    }

    public List<ConnectivityGroupItem> appliesToGroups() {
        return this.appliesToGroups;
    }

    public ConnectivityConfigurationProperties withAppliesToGroups(List<ConnectivityGroupItem> appliesToGroups) {
        this.appliesToGroups = appliesToGroups;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeleteExistingPeering deleteExistingPeering() {
        return this.deleteExistingPeering;
    }

    public ConnectivityConfigurationProperties withDeleteExistingPeering(DeleteExistingPeering deleteExistingPeering) {
        this.deleteExistingPeering = deleteExistingPeering;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.connectivityTopology() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property connectivityTopology in model ConnectivityConfigurationProperties"));
        }
        if (this.hubs() != null) {
            this.hubs().forEach(e -> e.validate());
        }
        if (this.appliesToGroups() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property appliesToGroups in model ConnectivityConfigurationProperties"));
        }
        this.appliesToGroups().forEach(e -> e.validate());
    }
}

