/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.BastionHostPropertiesFormat;
import com.azure.resourcemanager.network.models.BastionHostIpConfiguration;
import com.azure.resourcemanager.network.models.BastionHostPropertiesFormatNetworkAcls;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class BastionHostInner
extends Resource {
    @JsonProperty(value="properties")
    private BastionHostPropertiesFormat innerProperties;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="id")
    private String id;

    private BastionHostPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public BastionHostInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public Sku sku() {
        return this.sku;
    }

    public BastionHostInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String id() {
        return this.id;
    }

    public BastionHostInner withId(String id) {
        this.id = id;
        return this;
    }

    public BastionHostInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BastionHostInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<BastionHostIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public BastionHostInner withIpConfigurations(List<BastionHostIpConfiguration> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public String dnsName() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsName();
    }

    public BastionHostInner withDnsName(String dnsName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withDnsName(dnsName);
        return this;
    }

    public SubResource virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    public BastionHostInner withVirtualNetwork(SubResource virtualNetwork) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withVirtualNetwork(virtualNetwork);
        return this;
    }

    public BastionHostPropertiesFormatNetworkAcls networkAcls() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAcls();
    }

    public BastionHostInner withNetworkAcls(BastionHostPropertiesFormatNetworkAcls networkAcls) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withNetworkAcls(networkAcls);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Integer scaleUnits() {
        return this.innerProperties() == null ? null : this.innerProperties().scaleUnits();
    }

    public BastionHostInner withScaleUnits(Integer scaleUnits) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withScaleUnits(scaleUnits);
        return this;
    }

    public Boolean disableCopyPaste() {
        return this.innerProperties() == null ? null : this.innerProperties().disableCopyPaste();
    }

    public BastionHostInner withDisableCopyPaste(Boolean disableCopyPaste) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withDisableCopyPaste(disableCopyPaste);
        return this;
    }

    public Boolean enableFileCopy() {
        return this.innerProperties() == null ? null : this.innerProperties().enableFileCopy();
    }

    public BastionHostInner withEnableFileCopy(Boolean enableFileCopy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withEnableFileCopy(enableFileCopy);
        return this;
    }

    public Boolean enableIpConnect() {
        return this.innerProperties() == null ? null : this.innerProperties().enableIpConnect();
    }

    public BastionHostInner withEnableIpConnect(Boolean enableIpConnect) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withEnableIpConnect(enableIpConnect);
        return this;
    }

    public Boolean enableShareableLink() {
        return this.innerProperties() == null ? null : this.innerProperties().enableShareableLink();
    }

    public BastionHostInner withEnableShareableLink(Boolean enableShareableLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withEnableShareableLink(enableShareableLink);
        return this;
    }

    public Boolean enableTunneling() {
        return this.innerProperties() == null ? null : this.innerProperties().enableTunneling();
    }

    public BastionHostInner withEnableTunneling(Boolean enableTunneling) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withEnableTunneling(enableTunneling);
        return this;
    }

    public Boolean enableKerberos() {
        return this.innerProperties() == null ? null : this.innerProperties().enableKerberos();
    }

    public BastionHostInner withEnableKerberos(Boolean enableKerberos) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withEnableKerberos(enableKerberos);
        return this;
    }

    public Boolean enableSessionRecording() {
        return this.innerProperties() == null ? null : this.innerProperties().enableSessionRecording();
    }

    public BastionHostInner withEnableSessionRecording(Boolean enableSessionRecording) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BastionHostPropertiesFormat();
        }
        this.innerProperties().withEnableSessionRecording(enableSessionRecording);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

