/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ConfigurationType;
import com.azure.resourcemanager.network.models.NetworkManagerPropertiesNetworkManagerScopes;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class NetworkManagerProperties {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="networkManagerScopes", required=true)
    private NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes;
    @JsonProperty(value="networkManagerScopeAccesses", required=true)
    private List<ConfigurationType> networkManagerScopeAccesses;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkManagerProperties.class);

    public String description() {
        return this.description;
    }

    public NetworkManagerProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes() {
        return this.networkManagerScopes;
    }

    public NetworkManagerProperties withNetworkManagerScopes(NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes) {
        this.networkManagerScopes = networkManagerScopes;
        return this;
    }

    public List<ConfigurationType> networkManagerScopeAccesses() {
        return this.networkManagerScopeAccesses;
    }

    public NetworkManagerProperties withNetworkManagerScopeAccesses(List<ConfigurationType> networkManagerScopeAccesses) {
        this.networkManagerScopeAccesses = networkManagerScopeAccesses;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.networkManagerScopes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkManagerScopes in model NetworkManagerProperties"));
        }
        this.networkManagerScopes().validate();
        if (this.networkManagerScopeAccesses() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkManagerScopeAccesses in model NetworkManagerProperties"));
        }
    }
}

