/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.PacketCaptureFilter;
import com.azure.resourcemanager.network.models.PacketCaptureMachineScope;
import com.azure.resourcemanager.network.models.PacketCaptureSettings;
import com.azure.resourcemanager.network.models.PacketCaptureStorageLocation;
import com.azure.resourcemanager.network.models.PacketCaptureTargetType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class PacketCaptureParameters {
    @JsonProperty(value="target", required=true)
    private String target;
    @JsonProperty(value="scope")
    private PacketCaptureMachineScope scope;
    @JsonProperty(value="targetType")
    private PacketCaptureTargetType targetType;
    @JsonProperty(value="bytesToCapturePerPacket")
    private Long bytesToCapturePerPacket;
    @JsonProperty(value="totalBytesPerSession")
    private Long totalBytesPerSession;
    @JsonProperty(value="timeLimitInSeconds")
    private Integer timeLimitInSeconds;
    @JsonProperty(value="storageLocation", required=true)
    private PacketCaptureStorageLocation storageLocation;
    @JsonProperty(value="filters")
    private List<PacketCaptureFilter> filters;
    @JsonProperty(value="continuousCapture")
    private Boolean continuousCapture;
    @JsonProperty(value="captureSettings")
    private PacketCaptureSettings captureSettings;
    private static final ClientLogger LOGGER = new ClientLogger(PacketCaptureParameters.class);

    public String target() {
        return this.target;
    }

    public PacketCaptureParameters withTarget(String target) {
        this.target = target;
        return this;
    }

    public PacketCaptureMachineScope scope() {
        return this.scope;
    }

    public PacketCaptureParameters withScope(PacketCaptureMachineScope scope) {
        this.scope = scope;
        return this;
    }

    public PacketCaptureTargetType targetType() {
        return this.targetType;
    }

    public PacketCaptureParameters withTargetType(PacketCaptureTargetType targetType) {
        this.targetType = targetType;
        return this;
    }

    public Long bytesToCapturePerPacket() {
        return this.bytesToCapturePerPacket;
    }

    public PacketCaptureParameters withBytesToCapturePerPacket(Long bytesToCapturePerPacket) {
        this.bytesToCapturePerPacket = bytesToCapturePerPacket;
        return this;
    }

    public Long totalBytesPerSession() {
        return this.totalBytesPerSession;
    }

    public PacketCaptureParameters withTotalBytesPerSession(Long totalBytesPerSession) {
        this.totalBytesPerSession = totalBytesPerSession;
        return this;
    }

    public Integer timeLimitInSeconds() {
        return this.timeLimitInSeconds;
    }

    public PacketCaptureParameters withTimeLimitInSeconds(Integer timeLimitInSeconds) {
        this.timeLimitInSeconds = timeLimitInSeconds;
        return this;
    }

    public PacketCaptureStorageLocation storageLocation() {
        return this.storageLocation;
    }

    public PacketCaptureParameters withStorageLocation(PacketCaptureStorageLocation storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    public List<PacketCaptureFilter> filters() {
        return this.filters;
    }

    public PacketCaptureParameters withFilters(List<PacketCaptureFilter> filters) {
        this.filters = filters;
        return this;
    }

    public Boolean continuousCapture() {
        return this.continuousCapture;
    }

    public PacketCaptureParameters withContinuousCapture(Boolean continuousCapture) {
        this.continuousCapture = continuousCapture;
        return this;
    }

    public PacketCaptureSettings captureSettings() {
        return this.captureSettings;
    }

    public PacketCaptureParameters withCaptureSettings(PacketCaptureSettings captureSettings) {
        this.captureSettings = captureSettings;
        return this;
    }

    public void validate() {
        if (this.target() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property target in model PacketCaptureParameters"));
        }
        if (this.scope() != null) {
            this.scope().validate();
        }
        if (this.storageLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageLocation in model PacketCaptureParameters"));
        }
        this.storageLocation().validate();
        if (this.filters() != null) {
            this.filters().forEach(e -> e.validate());
        }
        if (this.captureSettings() != null) {
            this.captureSettings().validate();
        }
    }
}

