/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ConnectionMonitorResultProperties;
import com.azure.resourcemanager.network.models.ConnectionMonitorDestination;
import com.azure.resourcemanager.network.models.ConnectionMonitorEndpoint;
import com.azure.resourcemanager.network.models.ConnectionMonitorOutput;
import com.azure.resourcemanager.network.models.ConnectionMonitorSource;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestConfiguration;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestGroup;
import com.azure.resourcemanager.network.models.ConnectionMonitorType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ConnectionMonitorResultInner
extends Resource {
    private String etag;
    private ConnectionMonitorResultProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public String etag() {
        return this.etag;
    }

    private ConnectionMonitorResultProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ConnectionMonitorResultInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ConnectionMonitorResultInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public String monitoringStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().monitoringStatus();
    }

    public ConnectionMonitorType connectionMonitorType() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionMonitorType();
    }

    public ConnectionMonitorSource source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public ConnectionMonitorResultInner withSource(ConnectionMonitorSource source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionMonitorResultProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public ConnectionMonitorDestination destination() {
        return this.innerProperties() == null ? null : this.innerProperties().destination();
    }

    public ConnectionMonitorResultInner withDestination(ConnectionMonitorDestination destination) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionMonitorResultProperties();
        }
        this.innerProperties().withDestination(destination);
        return this;
    }

    public Boolean autoStart() {
        return this.innerProperties() == null ? null : this.innerProperties().autoStart();
    }

    public ConnectionMonitorResultInner withAutoStart(Boolean autoStart) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionMonitorResultProperties();
        }
        this.innerProperties().withAutoStart(autoStart);
        return this;
    }

    public Integer monitoringIntervalInSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().monitoringIntervalInSeconds();
    }

    public ConnectionMonitorResultInner withMonitoringIntervalInSeconds(Integer monitoringIntervalInSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionMonitorResultProperties();
        }
        this.innerProperties().withMonitoringIntervalInSeconds(monitoringIntervalInSeconds);
        return this;
    }

    public List<ConnectionMonitorEndpoint> endpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().endpoints();
    }

    public ConnectionMonitorResultInner withEndpoints(List<ConnectionMonitorEndpoint> endpoints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionMonitorResultProperties();
        }
        this.innerProperties().withEndpoints((List)endpoints);
        return this;
    }

    public List<ConnectionMonitorTestConfiguration> testConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().testConfigurations();
    }

    public ConnectionMonitorResultInner withTestConfigurations(List<ConnectionMonitorTestConfiguration> testConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionMonitorResultProperties();
        }
        this.innerProperties().withTestConfigurations((List)testConfigurations);
        return this;
    }

    public List<ConnectionMonitorTestGroup> testGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().testGroups();
    }

    public ConnectionMonitorResultInner withTestGroups(List<ConnectionMonitorTestGroup> testGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionMonitorResultProperties();
        }
        this.innerProperties().withTestGroups((List)testGroups);
        return this;
    }

    public List<ConnectionMonitorOutput> outputs() {
        return this.innerProperties() == null ? null : this.innerProperties().outputs();
    }

    public ConnectionMonitorResultInner withOutputs(List<ConnectionMonitorOutput> outputs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionMonitorResultProperties();
        }
        this.innerProperties().withOutputs((List)outputs);
        return this;
    }

    public String notes() {
        return this.innerProperties() == null ? null : this.innerProperties().notes();
    }

    public ConnectionMonitorResultInner withNotes(String notes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionMonitorResultProperties();
        }
        this.innerProperties().withNotes(notes);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionMonitorResultInner)((Object)jsonReader.readObject(reader -> {
            ConnectionMonitorResultInner deserializedConnectionMonitorResultInner = new ConnectionMonitorResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConnectionMonitorResultInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConnectionMonitorResultInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConnectionMonitorResultInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedConnectionMonitorResultInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedConnectionMonitorResultInner.withTags(tags);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedConnectionMonitorResultInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConnectionMonitorResultInner.innerProperties = ConnectionMonitorResultProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorResultInner;
        }));
    }
}

