/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.Container;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceConfiguration;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceIpConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ContainerNetworkInterfacePropertiesFormat
implements JsonSerializable<ContainerNetworkInterfacePropertiesFormat> {
    private ContainerNetworkInterfaceConfiguration containerNetworkInterfaceConfiguration;
    private Container container;
    private List<ContainerNetworkInterfaceIpConfiguration> ipConfigurations;
    private ProvisioningState provisioningState;

    public ContainerNetworkInterfaceConfiguration containerNetworkInterfaceConfiguration() {
        return this.containerNetworkInterfaceConfiguration;
    }

    public Container container() {
        return this.container;
    }

    public ContainerNetworkInterfacePropertiesFormat withContainer(Container container) {
        this.container = container;
        return this;
    }

    public List<ContainerNetworkInterfaceIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.containerNetworkInterfaceConfiguration() != null) {
            this.containerNetworkInterfaceConfiguration().validate();
        }
        if (this.container() != null) {
            this.container().validate();
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("container", (JsonSerializable)this.container);
        return jsonWriter.writeEndObject();
    }

    public static ContainerNetworkInterfacePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerNetworkInterfacePropertiesFormat)jsonReader.readObject(reader -> {
            ContainerNetworkInterfacePropertiesFormat deserializedContainerNetworkInterfacePropertiesFormat = new ContainerNetworkInterfacePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerNetworkInterfaceConfiguration".equals(fieldName)) {
                    deserializedContainerNetworkInterfacePropertiesFormat.containerNetworkInterfaceConfiguration = ContainerNetworkInterfaceConfiguration.fromJson(reader);
                    continue;
                }
                if ("container".equals(fieldName)) {
                    deserializedContainerNetworkInterfacePropertiesFormat.container = Container.fromJson(reader);
                    continue;
                }
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedContainerNetworkInterfacePropertiesFormat.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> ContainerNetworkInterfaceIpConfiguration.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedContainerNetworkInterfacePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerNetworkInterfacePropertiesFormat;
        });
    }
}

