/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleCollection;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class FirewallPolicyRuleCollectionGroupProperties
implements JsonSerializable<FirewallPolicyRuleCollectionGroupProperties> {
    private String size;
    private Integer priority;
    private List<FirewallPolicyRuleCollection> ruleCollections;
    private ProvisioningState provisioningState;

    public String size() {
        return this.size;
    }

    public Integer priority() {
        return this.priority;
    }

    public FirewallPolicyRuleCollectionGroupProperties withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public List<FirewallPolicyRuleCollection> ruleCollections() {
        return this.ruleCollections;
    }

    public FirewallPolicyRuleCollectionGroupProperties withRuleCollections(List<FirewallPolicyRuleCollection> ruleCollections) {
        this.ruleCollections = ruleCollections;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.ruleCollections() != null) {
            this.ruleCollections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeArrayField("ruleCollections", this.ruleCollections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FirewallPolicyRuleCollectionGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FirewallPolicyRuleCollectionGroupProperties)jsonReader.readObject(reader -> {
            FirewallPolicyRuleCollectionGroupProperties deserializedFirewallPolicyRuleCollectionGroupProperties = new FirewallPolicyRuleCollectionGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("size".equals(fieldName)) {
                    deserializedFirewallPolicyRuleCollectionGroupProperties.size = reader.getString();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedFirewallPolicyRuleCollectionGroupProperties.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("ruleCollections".equals(fieldName)) {
                    List ruleCollections;
                    deserializedFirewallPolicyRuleCollectionGroupProperties.ruleCollections = ruleCollections = reader.readArray(reader1 -> FirewallPolicyRuleCollection.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedFirewallPolicyRuleCollectionGroupProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirewallPolicyRuleCollectionGroupProperties;
        });
    }
}

