/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TransportProtocol;
import java.io.IOException;

public final class InboundNatPoolPropertiesFormat
implements JsonSerializable<InboundNatPoolPropertiesFormat> {
    private SubResource frontendIpConfiguration;
    private TransportProtocol protocol;
    private int frontendPortRangeStart;
    private int frontendPortRangeEnd;
    private int backendPort;
    private Integer idleTimeoutInMinutes;
    private Boolean enableFloatingIp;
    private Boolean enableTcpReset;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(InboundNatPoolPropertiesFormat.class);

    public SubResource frontendIpConfiguration() {
        return this.frontendIpConfiguration;
    }

    public InboundNatPoolPropertiesFormat withFrontendIpConfiguration(SubResource frontendIpConfiguration) {
        this.frontendIpConfiguration = frontendIpConfiguration;
        return this;
    }

    public TransportProtocol protocol() {
        return this.protocol;
    }

    public InboundNatPoolPropertiesFormat withProtocol(TransportProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public int frontendPortRangeStart() {
        return this.frontendPortRangeStart;
    }

    public InboundNatPoolPropertiesFormat withFrontendPortRangeStart(int frontendPortRangeStart) {
        this.frontendPortRangeStart = frontendPortRangeStart;
        return this;
    }

    public int frontendPortRangeEnd() {
        return this.frontendPortRangeEnd;
    }

    public InboundNatPoolPropertiesFormat withFrontendPortRangeEnd(int frontendPortRangeEnd) {
        this.frontendPortRangeEnd = frontendPortRangeEnd;
        return this;
    }

    public int backendPort() {
        return this.backendPort;
    }

    public InboundNatPoolPropertiesFormat withBackendPort(int backendPort) {
        this.backendPort = backendPort;
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public InboundNatPoolPropertiesFormat withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public Boolean enableFloatingIp() {
        return this.enableFloatingIp;
    }

    public InboundNatPoolPropertiesFormat withEnableFloatingIp(Boolean enableFloatingIp) {
        this.enableFloatingIp = enableFloatingIp;
        return this;
    }

    public Boolean enableTcpReset() {
        return this.enableTcpReset;
    }

    public InboundNatPoolPropertiesFormat withEnableTcpReset(Boolean enableTcpReset) {
        this.enableTcpReset = enableTcpReset;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.protocol() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocol in model InboundNatPoolPropertiesFormat"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeIntField("frontendPortRangeStart", this.frontendPortRangeStart);
        jsonWriter.writeIntField("frontendPortRangeEnd", this.frontendPortRangeEnd);
        jsonWriter.writeIntField("backendPort", this.backendPort);
        jsonWriter.writeJsonField("frontendIPConfiguration", (JsonSerializable)this.frontendIpConfiguration);
        jsonWriter.writeNumberField("idleTimeoutInMinutes", (Number)this.idleTimeoutInMinutes);
        jsonWriter.writeBooleanField("enableFloatingIP", this.enableFloatingIp);
        jsonWriter.writeBooleanField("enableTcpReset", this.enableTcpReset);
        return jsonWriter.writeEndObject();
    }

    public static InboundNatPoolPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (InboundNatPoolPropertiesFormat)jsonReader.readObject(reader -> {
            InboundNatPoolPropertiesFormat deserializedInboundNatPoolPropertiesFormat = new InboundNatPoolPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocol".equals(fieldName)) {
                    deserializedInboundNatPoolPropertiesFormat.protocol = TransportProtocol.fromString(reader.getString());
                    continue;
                }
                if ("frontendPortRangeStart".equals(fieldName)) {
                    deserializedInboundNatPoolPropertiesFormat.frontendPortRangeStart = reader.getInt();
                    continue;
                }
                if ("frontendPortRangeEnd".equals(fieldName)) {
                    deserializedInboundNatPoolPropertiesFormat.frontendPortRangeEnd = reader.getInt();
                    continue;
                }
                if ("backendPort".equals(fieldName)) {
                    deserializedInboundNatPoolPropertiesFormat.backendPort = reader.getInt();
                    continue;
                }
                if ("frontendIPConfiguration".equals(fieldName)) {
                    deserializedInboundNatPoolPropertiesFormat.frontendIpConfiguration = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedInboundNatPoolPropertiesFormat.idleTimeoutInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enableFloatingIP".equals(fieldName)) {
                    deserializedInboundNatPoolPropertiesFormat.enableFloatingIp = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableTcpReset".equals(fieldName)) {
                    deserializedInboundNatPoolPropertiesFormat.enableTcpReset = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedInboundNatPoolPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInboundNatPoolPropertiesFormat;
        });
    }
}

